/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.kml.KMLUtils;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSRequests;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;

public class KMLNetworkLinkTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    boolean encodeAsRegion = false;
    boolean cachedMode = false;
    private WMS wms;

    public KMLNetworkLinkTransformer(WMS wms) {
        this.wms = wms;
    }

    public void setCachedMode(boolean cachedMode) {
        this.cachedMode = cachedMode;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLNetworkLinkTranslator(handler);
    }

    public void setEncodeAsRegion(boolean encodeAsRegion) {
        this.encodeAsRegion = encodeAsRegion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KMLNetworkLinkTranslator
    extends TransformerBase.TranslatorSupport {
        public KMLNetworkLinkTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            GetMapRequest request = (GetMapRequest)o;
            this.start("kml");
            this.start("Folder");
            if (KMLNetworkLinkTransformer.this.encodeAsRegion) {
                this.encodeAsSuperOverlay(request);
            } else {
                this.encodeAsOverlay(request);
            }
            this.encodeLookAt(request);
            this.end("Folder");
            this.end("kml");
        }

        protected void encodeAsSuperOverlay(GetMapRequest request) {
            List<MapLayerInfo> layers = request.getLayers();
            List<Style> styles = request.getStyles();
            for (int i = 0; i < layers.size(); ++i) {
                if ("cached".equals(KMLUtils.getSuperoverlayMode(request, KMLNetworkLinkTransformer.this.wms)) && KMLUtils.isRequestGWCCompatible(request, i, KMLNetworkLinkTransformer.this.wms)) {
                    this.encodeGWCLink(request, layers.get(i));
                    continue;
                }
                this.encodeLayerSuperOverlay(request, layers, styles, i);
            }
        }

        public void encodeGWCLink(GetMapRequest request, MapLayerInfo mapLayer) {
            this.start("NetworkLink");
            String prefixedName = mapLayer.getResource().getPrefixedName();
            this.element("name", "GWC-" + prefixedName);
            this.start("Link");
            String type = mapLayer.getType() == MapLayerInfo.TYPE_RASTER ? "png" : "kml";
            String url = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)("gwc/service/kml/" + prefixedName + "." + type + ".kml"), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.element("href", url);
            this.element("viewRefreshMode", "never");
            this.end("Link");
            this.end("NetworkLink");
        }

        private void encodeLayerSuperOverlay(GetMapRequest request, List<MapLayerInfo> layers, List<Style> styles, int i) {
            this.start("NetworkLink");
            this.element("name", layers.get(i).getName());
            this.element("open", "1");
            this.element("visibility", "1");
            this.start("Region");
            Envelope bbox = request.getBbox();
            this.start("LatLonAltBox");
            this.element("north", "" + bbox.getMaxY());
            this.element("south", "" + bbox.getMinY());
            this.element("east", "" + bbox.getMaxX());
            this.element("west", "" + bbox.getMinX());
            this.end("LatLonAltBox");
            this.start("Lod");
            this.element("minLodPixels", "128");
            this.element("maxLodPixels", "-1");
            this.end("Lod");
            this.end("Region");
            this.start("Link");
            String style = i < styles.size() ? styles.get(i).getName() : null;
            String href = WMSRequests.getGetMapUrl(request, layers.get(i).getName(), i, style, null, null);
            try {
                href = URLDecoder.decode(href, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.start("href");
            this.cdata(href);
            this.end("href");
            this.end("Link");
            this.end("NetworkLink");
        }

        protected void encodeAsOverlay(GetMapRequest request) {
            List<MapLayerInfo> layers = request.getLayers();
            List<Style> styles = request.getStyles();
            for (int i = 0; i < layers.size(); ++i) {
                this.start("NetworkLink");
                this.element("name", layers.get(i).getName());
                this.element("open", "1");
                this.element("visibility", "1");
                this.start("Url");
                request.setBbox(null);
                String style = i < styles.size() ? styles.get(i).getName() : null;
                String href = WMSRequests.getGetMapUrl(request, layers.get(i).getName(), i, style, null, null);
                try {
                    href = URLDecoder.decode(href, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.element("viewRefreshMode", "onStop");
                this.element("viewRefreshTime", "1");
                this.end("Url");
                this.end("NetworkLink");
            }
        }

        private void encodeLookAt(GetMapRequest request) {
            Envelope e = new Envelope();
            e.setToNull();
            for (int i = 0; i < request.getLayers().size(); ++i) {
                MapLayerInfo layer = request.getLayers().get(i);
                ReferencedEnvelope b = null;
                try {
                    b = request.getLayers().get(i).getLatLongBoundingBox();
                }
                catch (IOException e1) {
                    LOGGER.warning("Unable to calculate bounds for " + layer.getName());
                    continue;
                }
                if (e.isNull()) {
                    e.init((Envelope)b);
                    continue;
                }
                e.expandToInclude((Envelope)b);
            }
            if (e.isNull()) {
                return;
            }
            double lon1 = e.getMinX();
            double lat1 = e.getMinY();
            double lon2 = e.getMaxX();
            double lat2 = e.getMaxY();
            double R_EARTH = 6371000.0;
            double VIEWER_WIDTH = 0.3839724354387525;
            double[] p1 = this.getRect(lon1, lat1, R_EARTH);
            double[] p2 = this.getRect(lon2, lat2, R_EARTH);
            double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
            midpoint = this.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
            double distance = this.distance(p1, p2);
            double height = distance / (2.0 * Math.tan(VIEWER_WIDTH));
            LOGGER.fine("lat1: " + lat1 + "; lon1: " + lon1);
            LOGGER.fine("lat2: " + lat2 + "; lon2: " + lon2);
            LOGGER.fine("latmid: " + midpoint[1] + "; lonmid: " + midpoint[0]);
            this.start("LookAt");
            this.element("longitude", "" + midpoint[0]);
            this.element("latitude", "" + midpoint[1]);
            this.element("altitude", "0");
            this.element("range", "" + distance);
            this.element("tilt", "0");
            this.element("heading", "0");
            this.element("altitudeMode", "clampToGround");
            this.end("LookAt");
        }

        private double[] getRect(double lat, double lon, double radius) {
            double theta = (90.0 - lat) * Math.PI / 180.0;
            double phi = (90.0 - lon) * Math.PI / 180.0;
            double x = radius * Math.sin(phi) * Math.cos(theta);
            double y = radius * Math.sin(phi) * Math.sin(theta);
            double z = radius * Math.cos(phi);
            return new double[]{x, y, z};
        }

        private double[] getGeographic(double x, double y, double z) {
            double radius = this.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
            double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
            double phi = Math.atan2(y, x);
            double lat = 90.0 - theta * 180.0 / Math.PI;
            double lon = 90.0 - phi * 180.0 / Math.PI;
            return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
        }

        private double distance(double[] p1, double[] p2) {
            double dx = p1[0] - p2[0];
            double dy = p1[1] - p2[1];
            double dz = p1[2] - p2[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }
}

