/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Geometry;
import org.geoserver.kml.KMLCoordinateWriter;
import org.geoserver.wms.WMSMapContext;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.xml.transform.Translator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class KMLGeometryTransformer
extends GeometryTransformer {
    static final String[] validAltitudeModes = new String[]{"relativeToGround", "absolute", "clampToGround"};

    public Translator createTranslator(ContentHandler handler, WMSMapContext context) {
        return new KMLGeometryTranslator(handler, this.numDecimals, this.useDummyZ, context);
    }

    public static class KMLGeometryTranslator
    extends GeometryTransformer.GeometryTranslator {
        private boolean extrude = true;
        private String altitudeMode = "relativeToGround";
        private boolean extrudeEnabled = true;
        private static final String[] GEOMETRYNAMES = new String[]{"Point", "LineString", "Polygon", "MultiPoint", "MultiLineString", "MultiPolygon", "GeometryCollection"};

        public KMLGeometryTranslator(ContentHandler handler, int numDecimals, boolean useDummyZ, WMSMapContext context) {
            super(handler, null, null, numDecimals, useDummyZ, 3);
            String requestedAltitudeMode;
            this.coordWriter = new KMLCoordinateWriter(numDecimals, useDummyZ);
            String extrudeValue = (String)context.getRequest().getFormatOptions().get("extrude");
            if (extrudeValue != null) {
                this.extrude = Boolean.valueOf(extrudeValue);
            }
            if ((requestedAltitudeMode = (String)context.getRequest().getFormatOptions().get("altitudeMode")) != null) {
                for (String mode : validAltitudeModes) {
                    if (!mode.equalsIgnoreCase(requestedAltitudeMode.trim())) continue;
                    this.altitudeMode = mode;
                }
            }
        }

        public void encode(Object o, String srsname) {
            if (o instanceof Geometry) {
                this.extrudeEnabled = this.inspectGeometry((Geometry)o);
            }
            super.encode(o, srsname);
        }

        public void encode(Object o) {
            if (o instanceof Geometry) {
                this.extrudeEnabled = this.inspectGeometry((Geometry)o);
            }
            super.encode(o);
        }

        public void encode(Geometry g, String srsname) {
            this.extrudeEnabled = this.inspectGeometry(g);
            super.encode(g, srsname);
        }

        public void encode(Geometry g) {
            this.extrudeEnabled = this.inspectGeometry(g);
            super.encode(g);
        }

        protected void start(String element, Attributes atts) {
            super.start(element, atts);
            if (this.isGeometryElement(element)) {
                this.insertExtrudeTags();
            }
        }

        private boolean inspectGeometry(Geometry g) {
            double d = g.getCoordinate().z;
            return !Double.isNaN(d) && d != 0.0;
        }

        public void insertExtrudeTags() {
            if (this.extrudeEnabled) {
                this.element("extrude", this.extrude ? "1" : "0");
                this.element("altitudeMode", this.altitudeMode);
            }
        }

        public void insertExtrudeTags(Geometry g) {
            if (this.inspectGeometry(g)) {
                this.element("extrude", this.extrude ? "1" : "0");
                this.element("altitudeMode", this.altitudeMode);
            }
        }

        private boolean isGeometryElement(String elementName) {
            for (String name : GEOMETRYNAMES) {
                if (!name.equals(elementName)) continue;
                return true;
            }
            return false;
        }
    }
}

