/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.media.jai.GraphicsJAI;
import org.geoserver.kml.AbortedException;
import org.geoserver.kml.KMLWriter;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EncodeKML {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.kml");
    private static final String KML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd\">\n";
    private static final String KML_FOOTER = "</kml>\n";
    private WMSMapContext mapContext;
    private KMLWriter writer;
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private boolean abortProcess;
    private WMS wms;

    public EncodeKML(WMS wms, WMSMapContext mapContext) {
        this.mapContext = mapContext;
        this.wms = wms;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void encodeKML(OutputStream out) throws IOException {
        this.writer = new KMLWriter(out, this.mapContext, this.wms);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            this.writeHeader();
            ArrayList layerRenderList = new ArrayList();
            this.writeLayers(false, layerRenderList);
            this.writeFooter();
            this.writer.flush();
            t = System.currentTimeMillis() - t;
            LOGGER.fine(new StringBuffer("KML generated, it took").append(t).append(" ms").toString());
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("KML encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    public void encodeKMZ(ZipOutputStream out) throws IOException {
        this.writer = new KMLWriter(out, this.mapContext, this.wms);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            ZipEntry e = new ZipEntry("wms.kml");
            out.putNextEntry(e);
            this.writeHeader();
            ArrayList layerRenderList = new ArrayList();
            this.writeLayers(true, layerRenderList);
            this.writeFooter();
            this.writer.flush();
            out.closeEntry();
            this.writeImages(out, layerRenderList);
            t = System.currentTimeMillis() - t;
            LOGGER.fine(new StringBuffer("KMZ generated, it took").append(t).append(" ms").toString());
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("KMZ encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    private boolean useVectorOutput(int kmscore, int numFeatures) {
        if (kmscore == 100) {
            return true;
        }
        if (kmscore == 0) {
            return false;
        }
        double magic = Math.pow(10.0, kmscore / 15);
        return !((double)numFeatures > magic);
    }

    private void writeHeader() throws IOException {
        this.writer.write(KML_HEADER);
    }

    private void writeFooter() throws IOException {
        this.writer.write(KML_FOOTER);
    }

    private void writeLayers(boolean kmz, ArrayList layerRenderList) throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int imageWidth = this.mapContext.getMapWidth();
        int imageHeight = this.mapContext.getMapHeight();
        if (nLayers > 1) {
            this.writer.startDocument("GeoServer", null);
        }
        for (int i = 0; i < nLayers; ++i) {
            MapLayer layer = layers[i];
            this.writer.startDocument(layer.getTitle(), null);
            SimpleFeatureSource fSource = (SimpleFeatureSource)layer.getFeatureSource();
            SimpleFeatureType schema = (SimpleFeatureType)fSource.getSchema();
            Rectangle paintArea = new Rectangle(imageWidth, imageHeight);
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)this.mapContext.getAreaOfInterest(), (Rectangle)paintArea);
            double scaleDenominator = 1.0;
            try {
                scaleDenominator = RendererUtilities.calculateScale((Envelope)this.mapContext.getAreaOfInterest(), (CoordinateReferenceSystem)this.mapContext.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                scaleDenominator = 1.0 / worldToScreen.getScaleX();
            }
            this.writer.setRequestedScale(scaleDenominator);
            boolean isRaster = false;
            List ats = schema.getAttributeDescriptors();
            int length = ats.size();
            String[] attributes = new String[length];
            for (int t = 0; t < length; ++t) {
                attributes[t] = ((AttributeDescriptor)ats.get(i)).getName().getLocalPart();
                if (!attributes[t].equals("grid")) continue;
                isRaster = true;
            }
            try {
                boolean useVector;
                CoordinateReferenceSystem sourceCrs = schema.getCoordinateReferenceSystem();
                this.writer.setSourceCrs(sourceCrs);
                ReferencedEnvelope envelope = this.mapContext.getAreaOfInterest();
                ReferencedEnvelope aoi = new ReferencedEnvelope((Envelope)envelope, this.mapContext.getCoordinateReferenceSystem());
                Filter filter = null;
                if (!CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)schema.getCoordinateReferenceSystem())) {
                    aoi = aoi.transform(schema.getCoordinateReferenceSystem(), true);
                }
                filter = this.createBBoxFilters(schema, attributes, (Envelope)aoi);
                Query q = new Query(schema.getTypeName());
                q.setFilter(filter);
                q.setPropertyNames(attributes);
                Query definitionQuery = layer.getQuery();
                if (definitionQuery != Query.ALL) {
                    q = q == Query.ALL ? definitionQuery : DataUtilities.mixQueries((Query)definitionQuery, (Query)q, (String)"KMLEncoder");
                }
                q.setCoordinateSystem(layer.getFeatureSource().getSchema().getCoordinateReferenceSystem());
                SimpleFeatureCollection fc = fSource.getFeatures(q);
                int kmscore = this.wms.getKmScore();
                Object kmScoreObj = this.mapContext.getRequest().getFormatOptions().get("kmscore");
                if (kmScoreObj != null) {
                    kmscore = (Integer)kmScoreObj;
                }
                if ((useVector = this.useVectorOutput(kmscore, fc.size())) || !kmz) {
                    LOGGER.info("Layer (" + layer.getTitle() + ") rendered with KML vector output.");
                    layerRenderList.add(new Integer(i));
                    if (!isRaster) {
                        this.writer.writeFeaturesAsVectors(fc, layer);
                    } else {
                        this.writer.writeCoverages(fc, layer);
                    }
                } else {
                    LOGGER.info("Layer (" + layer.getTitle() + ") rendered with KMZ raster output.");
                    this.writer.writeFeaturesAsRaster(fc, layer, i);
                }
                LOGGER.fine("finished writing");
            }
            catch (IOException ex) {
                LOGGER.info(new StringBuffer("process failed: ").append(ex.getMessage()).toString());
                throw ex;
            }
            catch (AbortedException ae) {
                LOGGER.info(new StringBuffer("process aborted: ").append(ae.getMessage()).toString());
                throw ae;
            }
            catch (Throwable t) {
                LOGGER.warning(new StringBuffer("UNCAUGHT exception: ").append(t.getMessage()).toString());
                IOException ioe = new IOException(new StringBuffer("UNCAUGHT exception: ").append(t.getMessage()).toString());
                ioe.setStackTrace(t.getStackTrace());
                throw ioe;
            }
            this.writer.endDocument();
        }
        if (nLayers > 1) {
            this.writer.endDocument();
        }
    }

    private void writeImages(ZipOutputStream outZ, ArrayList layerRenderList) throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        for (int i = 0; i < nLayers; ++i) {
            int num;
            if (layerRenderList.size() > 0 && (num = ((Integer)layerRenderList.get(0)).intValue()) == i) {
                layerRenderList.remove(0);
                continue;
            }
            MapLayer layer = layers[i];
            WMSMapContext map = this.mapContext;
            map.clearLayerList();
            map.addLayer(layer);
            int width = this.mapContext.getMapWidth();
            int height = this.mapContext.getMapHeight();
            LOGGER.fine(new StringBuffer("setting up ").append(width).append("x").append(height).append(" image").toString());
            BufferedImage curImage = new BufferedImage(width, height, 6);
            GraphicsJAI graphic = GraphicsJAI.createGraphicsJAI((Graphics2D)curImage.createGraphics(), null);
            LOGGER.fine("setting to transparent");
            int type = 2;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(this.mapContext.getBgColor().getRed(), this.mapContext.getBgColor().getGreen(), this.mapContext.getBgColor().getBlue(), 0);
            graphic.setBackground(this.mapContext.getBgColor());
            graphic.setColor(c);
            graphic.fillRect(0, 0, width, height);
            type = 3;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Rectangle paintArea = new Rectangle(width, height);
            StreamingRenderer renderer = new StreamingRenderer();
            renderer.setContext((MapContext)map);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderer.setJava2DHints(hints);
            HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
            rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
            rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
            renderer.setRendererHints(rendererParams);
            ReferencedEnvelope dataArea = map.getAreaOfInterest();
            AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)dataArea, (Rectangle)paintArea);
            renderer.paint((Graphics2D)graphic, paintArea, (Envelope)dataArea, at);
            graphic.dispose();
            ZipEntry e = new ZipEntry("layer_" + i + ".png");
            outZ.putNextEntry(e);
            new ImageWorker((RenderedImage)curImage).writePNG((Object)outZ, "FILTERED", 0.75f, false, false);
            outZ.closeEntry();
        }
    }

    private Filter createBBoxFilters(SimpleFeatureType schema, String[] attributes, Envelope bbox) throws IllegalFilterException {
        ArrayList<BBOX> filters = new ArrayList<BBOX>();
        int length = attributes.length;
        for (int j = 0; j < length; ++j) {
            AttributeDescriptor ad = schema.getDescriptor(attributes[j]);
            if (ad == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("Could not find '").append(attributes[j]).append("' in the FeatureType (").append(schema.getTypeName()).append(")").toString());
                }
                throw new IllegalFilterException(new StringBuffer("Could not find '").append(attributes[j] + "' in the FeatureType (").append(schema.getTypeName()).append(")").toString());
            }
            if (!(ad instanceof GeometryDescriptor)) continue;
            BBOX gfilter = this.filterFactory.bbox(ad.getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
            filters.add(gfilter);
        }
        if (filters.size() == 0) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return this.filterFactory.or(filters);
    }
}

