/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.version.undo;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.version.undo.Add;
import org.apache.wicket.version.undo.Change;
import org.apache.wicket.version.undo.ModelChange;
import org.apache.wicket.version.undo.Remove;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeList
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ChangeList.class);
    private final List<Change> changes = new ArrayList<Change>();

    ChangeList() {
    }

    void componentAdded(Component component) {
        this.changes.add(new Add(component));
    }

    void componentModelChanging(Component component) {
        this.changes.add(new ModelChange(component));
    }

    void componentStateChanging(Change change) {
        if (log.isDebugEnabled()) {
            log.debug("RECORD CHANGE: " + change);
        }
        this.changes.add(change);
    }

    void componentRemoved(Component component) {
        this.changes.add(new Remove(component));
    }

    void add(ChangeList list) {
        this.changes.addAll(list.changes);
    }

    void undo() {
        for (int i = this.changes.size() - 1; i >= 0; --i) {
            this.changes.get(i).undo();
        }
    }

    public String toString() {
        return this.changes.toString();
    }
}

