/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.util.Map;
import org.apache.wicket.behavior.StringHeaderContributor;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.template.CssTemplate;
import org.apache.wicket.util.template.JavaScriptTemplate;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTemplateHeaderContributor
extends StringHeaderContributor {
    private static final long serialVersionUID = 1L;

    public static TextTemplateHeaderContributor forCss(TextTemplate template, IModel<Map<String, Object>> variablesModel) {
        return new TextTemplateHeaderContributor(new CssTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forCss(Class<?> clazz, String fileName, IModel<Map<String, Object>> variablesModel) {
        return TextTemplateHeaderContributor.forCss(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(TextTemplate template, IModel<Map<String, Object>> variablesModel) {
        return new TextTemplateHeaderContributor(new JavaScriptTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(Class<?> clazz, String fileName, IModel<Map<String, Object>> variablesModel) {
        return TextTemplateHeaderContributor.forJavaScript(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    protected TextTemplateHeaderContributor(TextTemplate template, IModel<Map<String, Object>> variablesModel) {
        super(new TemplateModel(template, variablesModel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TemplateModel
    extends LoadableDetachableModel<String> {
        private static final long serialVersionUID = 1L;
        private final TextTemplate template;
        private final IModel<Map<String, Object>> variablesModel;

        protected TemplateModel(TextTemplate template, IModel<Map<String, Object>> variablesModel) {
            if (template == null) {
                throw new IllegalArgumentException("argument template must be not null");
            }
            this.template = template;
            this.variablesModel = variablesModel;
        }

        @Override
        public void detach() {
            if (this.variablesModel != null) {
                this.variablesModel.detach();
            }
            super.detach();
        }

        @Override
        protected String load() {
            Map<String, Object> variables;
            if (this.variablesModel != null && (variables = this.variablesModel.getObject()) != null) {
                return this.template.asString(variables);
            }
            return this.template.asString();
        }
    }
}

