/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.collections.ConcurrentHashSet;
import org.apache.wicket.util.resource.locator.ExtensionResourceNameIterator;
import org.apache.wicket.util.resource.locator.LocaleResourceNameIterator;
import org.apache.wicket.util.resource.locator.StyleAndVariationResourceNameIterator;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNameIterator
implements Iterator<String> {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("_([a-z]{2})(_([A-Z]{2})(_([^_]+))?)?$");
    private final Locale locale;
    private final String extensions;
    private final Iterator<String> styleIterator;
    private LocaleResourceNameIterator localeIterator;
    private Iterator<String> extenstionsIterator;
    private Locale currentLocale;
    private static final Set<String> isoCountries = new ConcurrentHashSet<String>(Arrays.asList(Locale.getISOCountries()));
    private static final Set<String> isoLanguages = new ConcurrentHashSet<String>(Arrays.asList(Locale.getISOLanguages()));

    public ResourceNameIterator(String path, String style, Locale locale, String extensions) {
        this.locale = locale;
        if (extensions == null && path.indexOf(46) != -1) {
            this.extensions = Strings.afterLast(path, '.');
            path = Strings.beforeLast(path, '.');
        } else {
            this.extensions = extensions;
        }
        String filename = Strings.lastPathComponent(path, '/');
        Matcher matcher = LOCALE_PATTERN.matcher(filename);
        if (matcher.find()) {
            String language = matcher.group(1);
            String country = matcher.group(3);
            String variant = matcher.group(5);
            if (language != null && !isoLanguages.contains(language)) {
                language = null;
                country = null;
                variant = null;
            }
            if (language != null && country != null && !isoCountries.contains(country)) {
                country = null;
                variant = null;
            }
            if (language != null) {
                path = path.substring(0, path.length() - filename.length() + matcher.start());
                this.localeIterator = new LocaleResourceNameIterator(path, new Locale(language, country != null ? country : "", variant != null ? variant : ""));
            }
        }
        this.styleIterator = new StyleAndVariationResourceNameIterator(path, style, null);
    }

    public final Locale getLocale() {
        return this.currentLocale;
    }

    @Override
    public boolean hasNext() {
        String newPath;
        if (this.extenstionsIterator != null) {
            if (this.extenstionsIterator.hasNext()) {
                return true;
            }
            this.extenstionsIterator = null;
        }
        if (this.localeIterator != null) {
            while (this.localeIterator.hasNext()) {
                newPath = this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
            this.localeIterator = null;
        }
        while (this.styleIterator.hasNext()) {
            newPath = this.styleIterator.next();
            this.localeIterator = new LocaleResourceNameIterator(newPath, this.locale);
            while (this.localeIterator.hasNext()) {
                newPath = this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String next() {
        if (this.extenstionsIterator != null) {
            return this.extenstionsIterator.next();
        }
        throw new WicketRuntimeException("Illegal call of next(). Iterator not properly initialized");
    }

    @Override
    public void remove() {
    }
}

