/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExternalResourceStream
extends AbstractResourceStream {
    InputStream in;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WebExternalResourceStream.class);
    private final String url;

    public WebExternalResourceStream(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument url must be not null");
        }
        this.url = url;
    }

    public long length() {
        return -1L;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public Time lastModifiedTime() {
        return null;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        ServletContext context = ((WebApplication)RequestCycle.get().getApplication()).getServletContext();
        this.in = context.getResourceAsStream(this.url);
        if (this.in == null) {
            throw new ResourceStreamNotFoundException("The requested resource was not found: " + this.url);
        }
        return this.in;
    }
}

