/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.converters.AbstractConverter;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;

    @Override
    public java.sql.Date convertToObject(String value, Locale locale) {
        if (value == null || Strings.isEmpty(value)) {
            return null;
        }
        return new java.sql.Date(((Date)this.parse(this.getDateFormat(locale), value, locale)).getTime());
    }

    @Override
    public String convertToString(Object value, Locale locale) {
        DateFormat dateFormat = this.getDateFormat(locale);
        if (dateFormat != null) {
            return dateFormat.format(value);
        }
        return value.toString();
    }

    public DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateFormat.getDateInstance(3, locale);
    }

    protected Class<java.sql.Date> getTargetType() {
        return java.sql.Date.class;
    }
}

