/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class WebRequestEncoder {
    boolean firstParameter = true;
    AppendingStringBuffer url;

    public WebRequestEncoder(AppendingStringBuffer url) {
        if (url.indexOf("?") >= 0) {
            this.firstParameter = false;
        }
        this.url = url;
    }

    public void addValue(String key, Object value) {
        if (value instanceof String[]) {
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                this.addValue(key, values[i]);
            }
        } else if (value instanceof String) {
            this.addValue(key, (String)value);
        } else {
            this.addValue(key, value.toString());
        }
    }

    public void addValue(String key, String value) {
        if (!this.firstParameter) {
            this.url.append('&');
        } else {
            this.firstParameter = false;
            this.url.append('?');
        }
        this.url.append(WicketURLEncoder.QUERY_INSTANCE.encode(key));
        this.url.append('=');
        this.url.append(WicketURLEncoder.QUERY_INSTANCE.encode(value));
    }
}

