/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.WebRequestEncoder;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.ValueMap;

public class URIRequestTargetUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    protected static final String URI = "uri";

    public URIRequestTargetUrlCodingStrategy(String mountPath) {
        super(mountPath);
    }

    public PageParameters decodeParameters(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        return new PageParameters(this.decodeParameters(parametersFragment, (Map)requestParameters.getParameters()));
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        return null;
    }

    public CharSequence encode(IRequestTarget requestTarget) {
        if (!(requestTarget instanceof IBookmarkablePageRequestTarget)) {
            throw new IllegalArgumentException("This encoder can only be used with instances of " + IBookmarkablePageRequestTarget.class.getName());
        }
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
        PageParameters pageParameters = target.getPageParameters();
        String pagemap = target.getPageMapName();
        if (pagemap != null) {
            if (pageParameters == null) {
                pageParameters = new PageParameters();
            }
            pageParameters.put("wicket:pageMapName", (Object)WebRequestCodingStrategy.encodePageMapName(pagemap));
        }
        this.appendParameters(url, (Map)pageParameters);
        return url;
    }

    public boolean matches(IRequestTarget requestTarget) {
        return false;
    }

    protected void appendParameters(AppendingStringBuffer url, Map parameters) {
        if (parameters.get(URI) != null) {
            url.append("/").append(parameters.get(URI));
        }
        if (!url.endsWith("/")) {
            url.append("/");
        }
        if (parameters != null && parameters.size() > 0) {
            Iterator entries = parameters.entrySet().iterator();
            WebRequestEncoder encoder = new WebRequestEncoder(url);
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getKey().equals(URI) || entry.getValue() == null) continue;
                encoder.addValue(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    protected ValueMap decodeParameters(String urlFragment, Map urlParameters) {
        if (urlFragment.startsWith("/")) {
            urlFragment = urlFragment.substring(1);
        }
        ValueMap parameters = new ValueMap();
        parameters.add(URI, urlFragment);
        if (urlParameters != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    protected String getURI(RequestParameters requestParameters) {
        return this.decodeParameters(requestParameters).getString(URI);
    }
}

