/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.upload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWebRequest
extends WebRequest {
    private static final Logger log = LoggerFactory.getLogger(ServletWebRequest.class);
    private final HttpServletRequest httpServletRequest;
    private int depthRelativeToWicketHandler = -1;
    private String relativePathPrefixToWicketHandler;
    private String relativePathPrefixToContextRoot;
    private Map parameterMap;
    private String wicketRedirectUrl;
    private int previousUrlDepth;
    private boolean ajax;
    private boolean forceNewVersion = false;

    public ServletWebRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
        this.ajax = false;
        String ajaxHeader = httpServletRequest.getHeader("Wicket-Ajax");
        if (Strings.isEmpty(ajaxHeader)) {
            ajaxHeader = httpServletRequest.getParameter("wicket:ajax");
        }
        if (!Strings.isEmpty(ajaxHeader)) {
            try {
                this.ajax = Strings.isTrue(ajaxHeader);
            }
            catch (StringValueConversionException e) {
                log.debug("Couldn't convert the Wicket-Ajax header: " + ajaxHeader);
            }
        }
    }

    public final HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public Locale getLocale() {
        return this.httpServletRequest.getLocale();
    }

    public String getParameter(String key) {
        return this.httpServletRequest.getParameter(key);
    }

    public Map getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap(this.httpServletRequest.getParameterMap());
        }
        return this.parameterMap;
    }

    public String[] getParameters(String key) {
        return this.httpServletRequest.getParameterValues(key);
    }

    public String getPath() {
        return ((WebApplication)Application.get()).getWicketFilter().getRelativePath(this.httpServletRequest);
    }

    public String getRelativePathPrefixToContextRoot() {
        if (this.relativePathPrefixToContextRoot != null) {
            return this.relativePathPrefixToContextRoot;
        }
        if (RequestContext.get().isPortletRequest()) {
            this.relativePathPrefixToContextRoot = this.getHttpServletRequest().getContextPath() + "/";
            return this.relativePathPrefixToContextRoot;
        }
        String tmp = this.getRelativePathPrefixToWicketHandler();
        PrependingStringBuffer prepender = new PrependingStringBuffer(tmp);
        String path = WicketURLDecoder.PATH_INSTANCE.decode(this.getPath());
        if (path == null || path.length() == 0) {
            path = "";
        }
        String wicketPath = "";
        String servletPath = this.getServletPath();
        if (servletPath.endsWith(path)) {
            int len = servletPath.length() - path.length() - 1;
            if (len < 0) {
                len = 0;
            }
            wicketPath = servletPath.substring(0, len);
        } else {
            wicketPath = servletPath;
        }
        for (int i = 0; i < wicketPath.length(); ++i) {
            if (wicketPath.charAt(i) != '/') continue;
            prepender.prepend("../");
        }
        this.relativePathPrefixToContextRoot = prepender.toString();
        return this.relativePathPrefixToContextRoot;
    }

    public int getDepthRelativeToWicketHandler() {
        if (this.depthRelativeToWicketHandler == -1) {
            this.getRelativePathPrefixToWicketHandler();
        }
        return this.depthRelativeToWicketHandler;
    }

    public String getRelativePathPrefixToWicketHandler() {
        if (this.relativePathPrefixToWicketHandler != null) {
            return this.relativePathPrefixToWicketHandler;
        }
        boolean portletRequest = RequestContext.get().isPortletRequest();
        PrependingStringBuffer prepender = new PrependingStringBuffer();
        if (!portletRequest && this.isAjax()) {
            for (int i = 0; i < this.getRequestParameters().getUrlDepth(); ++i) {
                prepender.prepend("../");
            }
            this.relativePathPrefixToWicketHandler = prepender.toString();
            return this.relativePathPrefixToWicketHandler;
        }
        String relativeUrl = this.getPath();
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        String errorUrl = (String)httpRequest.getAttribute("javax.servlet.error.request_uri");
        String forwardUrl = (String)httpRequest.getAttribute("javax.servlet.forward.servlet_path");
        String filterPath = (String)this.httpServletRequest.getAttribute("org.apache.wicket.filter.path");
        if (!Strings.isEmpty(forwardUrl)) {
            relativeUrl = forwardUrl.substring(1);
            relativeUrl = relativeUrl.substring(filterPath.length());
        } else if (!Strings.isEmpty(errorUrl)) {
            errorUrl = errorUrl.substring(httpRequest.getContextPath().length());
            relativeUrl = errorUrl.substring(1);
            relativeUrl = relativeUrl.substring(filterPath.length());
        } else if (this.wicketRedirectUrl != null) {
            relativeUrl = this.wicketRedirectUrl;
        }
        int lastPathPos = -1;
        if (this.depthRelativeToWicketHandler == -1) {
            int depth = 0;
            int ajaxUrlDepth = this.isAjax() ? this.getRequestParameters().getUrlDepth() : -1;
            for (int i = 0; i < relativeUrl.length() && relativeUrl.charAt(i) != '?'; ++i) {
                if (relativeUrl.charAt(i) != '/') continue;
                lastPathPos = i;
                if (++depth != ajaxUrlDepth) continue;
                return relativeUrl.substring(0, lastPathPos + 1);
            }
            this.depthRelativeToWicketHandler = depth;
        }
        if (portletRequest) {
            prepender.prepend("/");
            prepender.prepend(this.getHttpServletRequest().getServletPath());
            prepender.prepend(this.getHttpServletRequest().getContextPath());
        } else {
            for (int i = 0; i < this.depthRelativeToWicketHandler; ++i) {
                prepender.prepend("../");
            }
        }
        this.relativePathPrefixToWicketHandler = prepender.toString();
        return this.relativePathPrefixToWicketHandler;
    }

    public String getURL() {
        String queryString;
        String url = this.getServletPath();
        String pathInfo = this.httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            url = url + pathInfo;
        }
        if ((queryString = this.httpServletRequest.getQueryString()) != null) {
            url = url + "?" + queryString;
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    public String getServletPath() {
        return this.httpServletRequest.getServletPath();
    }

    public final boolean isAjax() {
        return this.ajax;
    }

    public final void setAjax(boolean ajax) {
        this.ajax = ajax;
    }

    public boolean mergeVersion() {
        if (this.forceNewVersion) {
            return false;
        }
        RequestListenerInterface intface = this.getRequestParameters().getInterface();
        return this.isAjax() || intface == IRedirectListener.INTERFACE;
    }

    public void setForceNewVersion(boolean forceNewVersion) {
        this.forceNewVersion = forceNewVersion;
    }

    public WebRequest newMultipartWebRequest(Bytes maxsize) {
        try {
            MultipartServletWebRequest multipart = new MultipartServletWebRequest(this.httpServletRequest, maxsize);
            multipart.setRequestParameters(this.getRequestParameters());
            return multipart;
        }
        catch (FileUploadException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public void setWicketRedirectUrl(String wicketRedirectUrl) {
        this.wicketRedirectUrl = wicketRedirectUrl;
        this.depthRelativeToWicketHandler = -1;
        this.relativePathPrefixToContextRoot = null;
        this.relativePathPrefixToWicketHandler = null;
        if (wicketRedirectUrl != null) {
            this.previousUrlDepth = this.getRequestParameters().getUrlDepth();
            this.getRequestParameters().setUrlDepth(this.getDepthRelativeToWicketHandler());
        } else {
            this.getRequestParameters().setUrlDepth(this.previousUrlDepth);
            this.getDepthRelativeToWicketHandler();
        }
    }

    public String getQueryString() {
        return this.httpServletRequest.getQueryString();
    }

    public String toString() {
        return "[method = " + this.httpServletRequest.getMethod() + ", protocol = " + this.httpServletRequest.getProtocol() + ", requestURL = " + this.httpServletRequest.getRequestURL() + ", contentType = " + this.httpServletRequest.getContentType() + ", contentLength = " + this.httpServletRequest.getContentLength() + ", contextPath = " + this.httpServletRequest.getContextPath() + ", pathInfo = " + this.httpServletRequest.getPathInfo() + ", requestURI = " + this.httpServletRequest.getRequestURI() + ", servletPath = " + this.httpServletRequest.getServletPath() + ", pathTranslated = " + this.httpServletRequest.getPathTranslated() + "]";
    }
}

