/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.portlet.FilterRequestContext;
import org.apache.wicket.protocol.http.portlet.PortletInvalidMarkupFilter;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.protocol.http.portlet.PortletServletRequestWrapper;
import org.apache.wicket.protocol.http.portlet.PortletServletResponseWrapper;
import org.apache.wicket.protocol.http.portlet.ServletPortletSessionProxy;
import org.apache.wicket.protocol.http.portlet.WicketPortlet;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.settings.IRequestCycleSettings;

public class WicketFilterPortletContext {
    private static final String SERVLET_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX = "/ps:";
    private static final char[] slashReplacers = new char[]{'!', '@', '$', '-', '_', '|', ',', '.', '9', '8', '7', '6', '5', '4', '3', '2', '1', 'z', 'y', 'x', 'w', 'v', 'u', 't', 's', 'r', 'q', 'p', 'o', 'm', 'n', 'l', 'k', 'j', 'i', 'h', 'g', 'f', 'e', 'd', 'c', 'b', 'a'};

    public void initFilter(FilterConfig filterConfig, WebApplication webApplication) throws ServletException {
        webApplication.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.REDIRECT_TO_RENDER);
        webApplication.getRequestCycleSettings().addResponseFilter(new PortletInvalidMarkupFilter());
    }

    public boolean setupFilter(FilterConfig config, FilterRequestContext filterRequestContext, String filterPath) throws IOException, ServletException {
        boolean inPortletContext = false;
        PortletConfig portletConfig = (PortletConfig)filterRequestContext.getRequest().getAttribute("javax.portlet.config");
        if (portletConfig != null) {
            inPortletContext = true;
            PortletRequest portletRequest = (PortletRequest)filterRequestContext.getRequest().getAttribute("javax.portlet.request");
            WicketResponseState responseState = (WicketResponseState)filterRequestContext.getRequest().getAttribute(WicketPortlet.RESPONSE_STATE_ATTR);
            filterRequestContext.setRequest((HttpServletRequest)new PortletServletRequestWrapper(config.getServletContext(), filterRequestContext.getRequest(), ServletPortletSessionProxy.createProxy(filterRequestContext.getRequest(), portletRequest.getWindowID()), filterPath));
            filterRequestContext.setResponse((HttpServletResponse)new PortletServletResponseWrapper(filterRequestContext.getResponse(), responseState));
        } else {
            ServletContext context = config.getServletContext();
            HttpServletRequest request = filterRequestContext.getRequest();
            String pathInfo = request.getRequestURI().substring(request.getContextPath().length() + filterPath.length());
            String portletWindowId = this.decodePortletWindowId(pathInfo);
            if (portletWindowId != null) {
                HttpSession proxiedSession = ServletPortletSessionProxy.createProxy(request, portletWindowId);
                pathInfo = this.stripWindowIdFromPathInfo(pathInfo);
                filterRequestContext.setRequest((HttpServletRequest)new PortletServletRequestWrapper(context, request, proxiedSession, filterPath, pathInfo));
            }
        }
        return inPortletContext;
    }

    public boolean createPortletRequestContext(WebRequest request, WebResponse response) {
        if (request.getHttpServletRequest().getAttribute("javax.portlet.config") != null) {
            this.newPortletRequestContext((ServletWebRequest)request, response);
            return true;
        }
        return false;
    }

    public String getServletResourceUrlPortletWindowIdPrefix() {
        return SERVLET_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX;
    }

    public String decodePortletWindowId(String pathInfo) {
        int nextPath;
        String portletWindowId = null;
        if (pathInfo != null && pathInfo.startsWith(this.getServletResourceUrlPortletWindowIdPrefix()) && (portletWindowId = (nextPath = pathInfo.indexOf(47, 1)) > -1 ? pathInfo.substring(this.getServletResourceUrlPortletWindowIdPrefix().length(), nextPath) : pathInfo.substring(this.getServletResourceUrlPortletWindowIdPrefix().length())).length() > 2 && portletWindowId.charAt(0) == ':') {
            char slashEncoder = portletWindowId.charAt(2);
            portletWindowId = portletWindowId.substring(2);
            if (slashEncoder != ':') {
                portletWindowId = portletWindowId.replace(slashEncoder, '/');
            }
        }
        return portletWindowId;
    }

    public String stripWindowIdFromPathInfo(String pathInfo) {
        if (pathInfo != null && pathInfo.startsWith(this.getServletResourceUrlPortletWindowIdPrefix())) {
            int nextPath = pathInfo.indexOf(47, 1);
            pathInfo = nextPath > -1 ? pathInfo.substring(nextPath) : null;
        }
        return pathInfo;
    }

    public String encodeWindowIdInPath(String windowId, CharSequence path) {
        if (windowId != null && windowId.length() > 0) {
            if (windowId.indexOf(47) > -1) {
                boolean replaced = false;
                for (char replacer : slashReplacers) {
                    if (windowId.indexOf(replacer) != -1) continue;
                    windowId = ":" + replacer + windowId.replace('/', replacer);
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    throw new RuntimeException("PortletRequest.getWindowId() contains a '/' character for which no valid and unique replacer could be determined: " + windowId);
                }
            } else if (windowId.charAt(0) == ':') {
                windowId = "::" + windowId;
            }
        }
        return this.getServletResourceUrlPortletWindowIdPrefix().substring(1) + windowId + "/" + path;
    }

    protected void newPortletRequestContext(ServletWebRequest request, WebResponse response) {
        new PortletRequestContext(this, request, response);
    }
}

