/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSession
extends Session {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WebSession.class);
    private static final IFeedbackMessageFilter MESSAGES_FOR_COMPONENTS = new IFeedbackMessageFilter(){
        private static final long serialVersionUID = 1L;

        public boolean accept(FeedbackMessage message) {
            return message.getReporter() != null;
        }
    };
    private static final IFeedbackMessageFilter RENDERED_SESSION_SCOPED_MESSAGES = new IFeedbackMessageFilter(){
        private static final long serialVersionUID = 1L;

        public boolean accept(FeedbackMessage message) {
            return message.getReporter() == null && message.isRendered();
        }
    };

    @Deprecated
    public WebSession(Application application, Request request) {
        super(application, request);
    }

    @Deprecated
    public WebSession(WebApplication application, Request request) {
        super(application, request);
    }

    public WebSession(Request request) {
        super(request);
    }

    protected boolean isCurrentRequestValid(RequestCycle lockedRequestCycle) {
        WebRequest lockedRequest = (WebRequest)lockedRequestCycle.getRequest();
        if (lockedRequest.isAjax()) {
            return true;
        }
        if (IResourceListener.INTERFACE.equals(lockedRequest.getRequestParameters().getInterface())) {
            return true;
        }
        RequestCycle currentRequestCycle = RequestCycle.get();
        WebRequest currentRequest = (WebRequest)currentRequestCycle.getRequest();
        if (!currentRequest.isAjax()) {
            return true;
        }
        String lockedPageId = Strings.firstPathComponent(lockedRequest.getRequestParameters().getComponentPath(), ':');
        String currentPageId = Strings.firstPathComponent(currentRequestCycle.getRequest().getRequestParameters().getComponentPath(), ':');
        int lockedVersion = lockedRequest.getRequestParameters().getVersionNumber();
        int currentVersion = currentRequest.getRequestParameters().getVersionNumber();
        return !currentPageId.equals(lockedPageId) || currentVersion != lockedVersion;
    }

    public void cleanupFeedbackMessages() {
        if (Application.get().getRequestCycleSettings().getRenderStrategy() != IRequestCycleSettings.REDIRECT_TO_RENDER || ((WebRequest)RequestCycle.get().getRequest()).isAjax() || !RequestCycle.get().isRedirect()) {
            if (this.getFeedbackMessages().clear(RENDERED_SESSION_SCOPED_MESSAGES) > 0) {
                this.dirty();
            }
            if ("development".equals(this.getApplication().getConfigurationType())) {
                List<FeedbackMessage> messages = this.getFeedbackMessages().messages(MESSAGES_FOR_COMPONENTS);
                for (FeedbackMessage message : messages) {
                    if (message.isRendered()) continue;
                    logger.warn("Component-targetted feedback message was left unrendered. This could be because you are missing a FeedbackPanel on the page.  Message: {}", (Object)message);
                }
            }
            this.cleanupComponentFeedbackMessages();
        }
    }

    protected void cleanupComponentFeedbackMessages() {
        this.getFeedbackMessages().clear(MESSAGES_FOR_COMPONENTS);
    }
}

