/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestLogger
implements IRequestLogger {
    protected static Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private static MetaDataKey<IRequestLogger.RequestData> REQUEST_DATA = new MetaDataKey<IRequestLogger.RequestData>(){
        private static final long serialVersionUID = 1L;
    };
    private final AtomicInteger totalCreatedSessions = new AtomicInteger();
    private final AtomicInteger peakSessions = new AtomicInteger();
    private final List<IRequestLogger.RequestData> requests;
    private final Map<String, SessionData> liveSessions;
    private final AtomicInteger active = new AtomicInteger();

    public RequestLogger() {
        this.requests = Collections.synchronizedList(new LinkedList<IRequestLogger.RequestData>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void add(int index, IRequestLogger.RequestData o) {
                super.add(index, o);
                if (this.size() > Application.get().getRequestLoggerSettings().getRequestsWindowSize()) {
                    this.removeLast();
                }
            }
        });
        this.liveSessions = new ConcurrentHashMap<String, SessionData>();
    }

    @Override
    public int getTotalCreatedSessions() {
        return this.totalCreatedSessions.get();
    }

    @Override
    public int getPeakSessions() {
        return this.peakSessions.get();
    }

    @Override
    public int getCurrentActiveRequestCount() {
        return this.active.get();
    }

    @Override
    public List<IRequestLogger.RequestData> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    @Override
    public SessionData[] getLiveSessions() {
        Object[] sessions = this.liveSessions.values().toArray(new SessionData[this.liveSessions.values().size()]);
        Arrays.sort(sessions);
        return sessions;
    }

    @Override
    public void sessionDestroyed(String sessionId) {
        this.liveSessions.remove(sessionId);
    }

    @Override
    public void sessionCreated(String sessionId) {
        this.liveSessions.put(sessionId, new SessionData(sessionId));
        if (this.liveSessions.size() > this.peakSessions.get()) {
            this.peakSessions.set(this.liveSessions.size());
        }
        this.totalCreatedSessions.incrementAndGet();
    }

    IRequestLogger.RequestData getCurrentRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.RequestData rd = requestCycle.getMetaData(REQUEST_DATA);
        if (rd == null) {
            rd = new IRequestLogger.RequestData();
            requestCycle.setMetaData(REQUEST_DATA, rd);
            this.active.incrementAndGet();
        }
        return rd;
    }

    @Override
    public void requestTime(long timeTaken) {
        IRequestLogger.RequestData rd = RequestCycle.get().getMetaData(REQUEST_DATA);
        if (rd != null) {
            if (this.active.get() > 0) {
                rd.setActiveRequest(this.active.decrementAndGet());
            }
            Session session = Session.get();
            String sessionId = session.getId();
            rd.setSessionId(sessionId);
            Object sessionInfo = this.getSessionInfo(session);
            rd.setSessionInfo(sessionInfo);
            long sizeInBytes = -1L;
            if (Application.get().getRequestLoggerSettings().getRecordSessionSize()) {
                try {
                    sizeInBytes = session.getSizeInBytes();
                }
                catch (Exception e) {
                    log.error("Exception while determining the size of the session in the request logger: " + e.getMessage(), (Throwable)e);
                }
            }
            rd.setSessionSize(sizeInBytes);
            rd.setTimeTaken(timeTaken);
            this.requests.add(0, rd);
            if (sessionId != null) {
                SessionData sd = this.liveSessions.get(sessionId);
                if (sd == null && !session.isSessionInvalidated()) {
                    this.sessionCreated(sessionId);
                    sd = this.liveSessions.get(sessionId);
                }
                if (sd != null) {
                    sd.setSessionInfo(sessionInfo);
                    sd.setSessionSize(sizeInBytes);
                    sd.addTimeTaken(timeTaken);
                    this.log(rd, sd);
                } else {
                    this.log(rd, null);
                }
            } else {
                this.log(rd, null);
            }
        }
    }

    protected void log(IRequestLogger.RequestData rd, SessionData sd) {
        if (log.isInfoEnabled()) {
            log.info(this.createLogString(rd, sd, true).toString());
        }
    }

    protected final AppendingStringBuffer createLogString(IRequestLogger.RequestData rd, SessionData sd, boolean includeRuntimeInfo) {
        AppendingStringBuffer asb = new AppendingStringBuffer(150);
        asb.append("time=");
        asb.append(rd.getTimeTaken());
        asb.append(",event=");
        asb.append(rd.getEventTarget());
        asb.append(",response=");
        asb.append(rd.getResponseTarget());
        if (rd.getSessionInfo() != null && !rd.getSessionInfo().equals("")) {
            asb.append(",sessioninfo=");
            asb.append(rd.getSessionInfo());
        } else {
            asb.append(",sessionid=");
            asb.append(rd.getSessionId());
        }
        asb.append(",sessionsize=");
        asb.append(rd.getSessionSize());
        if (sd != null) {
            asb.append(",sessionstart=");
            asb.append(sd.getStartDate());
            asb.append(",requests=");
            asb.append(sd.getNumberOfRequests());
            asb.append(",totaltime=");
            asb.append(sd.getTotalTimeTaken());
        }
        asb.append(",activerequests=");
        asb.append(rd.getActiveRequest());
        if (includeRuntimeInfo) {
            Runtime runtime = Runtime.getRuntime();
            long max = runtime.maxMemory() / 1000000L;
            long total = runtime.totalMemory() / 1000000L;
            long used = total - runtime.freeMemory() / 1000000L;
            asb.append(",maxmem=");
            asb.append(max);
            asb.append("M,total=");
            asb.append(total);
            asb.append("M,used=");
            asb.append(used);
            asb.append("M");
        }
        return asb;
    }

    private Object getSessionInfo(Session session) {
        if (session instanceof ISessionLogInfo) {
            return ((ISessionLogInfo)((Object)session)).getSessionInfo();
        }
        return "";
    }

    @Override
    public void objectRemoved(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page removed, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap removed, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else if (value instanceof WebSession) {
            rd.addEntry("Session removed");
        } else {
            rd.addEntry("Custom object removed: " + value);
        }
    }

    @Override
    public void objectUpdated(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page updated, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap updated, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else if (value instanceof Session) {
            rd.addEntry("Session updated");
        } else {
            rd.addEntry("Custom object updated: " + value);
        }
    }

    @Override
    public void objectCreated(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Session) {
            rd.addEntry("Session created");
        } else if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page created, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap created, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else {
            rd.addEntry("Custom object created: " + value);
        }
    }

    @Override
    public void logResponseTarget(IRequestTarget target) {
        this.getCurrentRequest().addResponseTarget(this.getRequestTargetString(target));
    }

    @Override
    public void logEventTarget(IRequestTarget target) {
        this.getCurrentRequest().addEventTarget(this.getRequestTargetString(target));
    }

    private String getRequestTargetString(IRequestTarget target) {
        AppendingStringBuffer sb = new AppendingStringBuffer(128);
        if (target instanceof IListenerInterfaceRequestTarget) {
            IListenerInterfaceRequestTarget listener = (IListenerInterfaceRequestTarget)target;
            sb.append("Interface[target:");
            sb.append(Classes.simpleName(listener.getTarget().getClass()));
            sb.append("(");
            sb.append(listener.getTarget().getPageRelativePath());
            sb.append("), page: ");
            sb.append(listener.getPage().getClass().getName());
            sb.append("(");
            sb.append(listener.getPage().getId());
            sb.append("), interface: ");
            sb.append(listener.getRequestListenerInterface().getName());
            sb.append(".");
            sb.append(listener.getRequestListenerInterface().getMethod().getName());
            sb.append("]");
        } else if (target instanceof IPageRequestTarget) {
            IPageRequestTarget pageRequestTarget = (IPageRequestTarget)target;
            sb.append("PageRequest[");
            sb.append(pageRequestTarget.getPage().getClass().getName());
            sb.append("(");
            sb.append(pageRequestTarget.getPage().getId());
            sb.append(")]");
        } else if (target instanceof IBookmarkablePageRequestTarget) {
            IBookmarkablePageRequestTarget pageRequestTarget = (IBookmarkablePageRequestTarget)target;
            sb.append("BookmarkablePage[");
            sb.append(pageRequestTarget.getPageClass().getName());
            sb.append("(").append(pageRequestTarget.getPageParameters()).append(")");
            sb.append("]");
        } else if (target instanceof ISharedResourceRequestTarget) {
            ISharedResourceRequestTarget sharedResourceTarget = (ISharedResourceRequestTarget)target;
            sb.append("SharedResource[");
            sb.append(sharedResourceTarget.getResourceKey());
            sb.append("]");
        } else {
            sb.append(target.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SessionData
    implements IClusterable,
    Comparable<SessionData> {
        private static final long serialVersionUID = 1L;
        private final String sessionId;
        private final long startDate;
        private long lastActive;
        private long numberOfRequests;
        private long totalTimeTaken;
        private long sessionSize;
        private Object sessionInfo;

        public SessionData(String sessionId) {
            this.sessionId = sessionId;
            this.startDate = System.currentTimeMillis();
            this.numberOfRequests = 1L;
        }

        public Date getLastActive() {
            return new Date(this.lastActive);
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public long getNumberOfRequests() {
            return this.numberOfRequests;
        }

        public long getSessionSize() {
            return this.sessionSize;
        }

        public long getTotalTimeTaken() {
            return this.totalTimeTaken;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void addTimeTaken(long time) {
            this.lastActive = System.currentTimeMillis();
            ++this.numberOfRequests;
            this.totalTimeTaken += time;
        }

        public void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public void setSessionSize(long size) {
            this.sessionSize = size;
        }

        @Override
        public int compareTo(SessionData sd) {
            return (int)(sd.lastActive - this.lastActive);
        }
    }

    public static interface ISessionLogInfo {
        public Object getSessionInfo();
    }
}

