/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceModel
extends AbstractReadOnlyModel<String>
implements IComponentAssignedModel<String> {
    private static final long serialVersionUID = 1L;
    private final String resourceKey;
    private final String defaultValue;

    public ResourceModel(String resourceKey) {
        this(resourceKey, null);
    }

    public ResourceModel(String resourceKey, String defaultValue) {
        this.resourceKey = resourceKey;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getObject() {
        return Application.get().getResourceSettings().getLocalizer().getString(this.resourceKey, (Component)null, this.defaultValue);
    }

    @Override
    public IWrapModel<String> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(this.resourceKey, this.defaultValue, component);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AssignmentWrapper
    extends ResourceModel
    implements IWrapModel<String> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(String resourceKey, String defaultValue, Component component) {
            super(resourceKey, defaultValue);
            this.component = component;
        }

        @Override
        public IModel<String> getWrappedModel() {
            return ResourceModel.this;
        }

        @Override
        public String getObject() {
            return Application.get().getResourceSettings().getLocalizer().getString(ResourceModel.this.resourceKey, this.component, ResourceModel.this.defaultValue);
        }

        @Override
        public void detach() {
            super.detach();
            ResourceModel.this.detach();
        }
    }
}

