/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlProblemFinder
extends AbstractMarkupFilter {
    private static final Logger log = LoggerFactory.getLogger(HtmlProblemFinder.class);
    public static final int ERR_INGORE = 3;
    public static final int ERR_LOG_WARN = 2;
    public static final int ERR_LOG_ERROR = 1;
    public static final int ERR_THROW_EXCEPTION = 0;
    private final int problemEscalation;

    public HtmlProblemFinder(int problemEscalation) {
        this.problemEscalation = problemEscalation;
    }

    public MarkupElement nextTag() throws ParseException {
        String src;
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag == null) {
            return tag;
        }
        if ("img".equals(tag.getName()) && (tag.isOpen() || tag.isOpenClose()) && (src = tag.getAttributes().getString("src")) != null && src.trim().length() == 0) {
            this.escalateWarning("Attribute 'src' should not be empty. Location: ", tag);
        }
        for (String key : tag.getAttributes().keySet()) {
            if (key == null || !(key = key.toLowerCase()).startsWith("wicket.")) continue;
            this.escalateWarning("You probably want 'wicket:xxx' rather than 'wicket.xxx'. Location: ", tag);
        }
        return tag;
    }

    private void escalateWarning(String msg, ComponentTag tag) throws ParseException {
        if (this.problemEscalation == 2) {
            log.warn(msg + tag.toUserDebugString());
        } else if (this.problemEscalation == 1) {
            log.error(msg + tag.toUserDebugString());
        } else if (this.problemEscalation != 3) {
            throw new ParseException(msg + tag.toUserDebugString(), tag.getPos());
        }
    }
}

