/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.response.NullResponse;
import org.apache.wicket.util.string.JavascriptUtils;
import org.apache.wicket.util.string.Strings;

public abstract class HeaderResponse
implements IHeaderResponse {
    private static final long serialVersionUID = 1L;
    private final Set<Object> rendered = new HashSet<Object>();
    private boolean closed;

    public HeaderResponse() {
        if (Application.exists()) {
            Application.get().notifyRenderHeadListener(this);
        }
    }

    public final void markRendered(Object object) {
        this.rendered.add(object);
    }

    public void renderCSSReference(ResourceReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        if (!this.closed) {
            CharSequence url = RequestCycle.get().urlFor(reference);
            this.renderCSSReference(((Object)url).toString(), null);
        }
    }

    public void renderCSSReference(ResourceReference reference, String media) {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        if (!this.closed) {
            CharSequence url = RequestCycle.get().urlFor(reference);
            this.renderCSSReference(((Object)url).toString(), media);
        }
    }

    public void renderCSSReference(String url) {
        if (Strings.isEmpty(url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed) {
            this.renderCSSReference(url, null);
        }
    }

    public void renderCSSReference(String url, String media) {
        List<Object> token;
        if (Strings.isEmpty(url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed && !this.wasRendered(token = Arrays.asList("css", url, media))) {
            this.getResponse().write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            this.getResponse().write(url);
            this.getResponse().write("\"");
            if (media != null) {
                this.getResponse().write(" media=\"");
                this.getResponse().write(media);
                this.getResponse().write("\"");
            }
            this.getResponse().println(" />");
            this.markRendered(token);
        }
    }

    public void renderJavascriptReference(ResourceReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        if (!this.closed) {
            CharSequence url = RequestCycle.get().urlFor(reference);
            this.renderJavascriptReference(((Object)url).toString());
        }
    }

    public void renderJavascriptReference(ResourceReference reference, String id) {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        if (!this.closed) {
            CharSequence url = RequestCycle.get().urlFor(reference);
            this.renderJavascriptReference(((Object)url).toString(), id);
        }
    }

    public void renderJavascriptReference(String url) {
        List<Object> token;
        if (Strings.isEmpty(url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed && !this.wasRendered(token = Arrays.asList("javascript", url))) {
            JavascriptUtils.writeJavascriptUrl(this.getResponse(), url);
            this.markRendered(token);
        }
    }

    public void renderJavascriptReference(String url, String id) {
        if (Strings.isEmpty(url)) {
            throw new IllegalArgumentException("url cannot be empty or null");
        }
        if (!this.closed) {
            List<Object> token1 = Arrays.asList("javascript", url);
            List<Object> token2 = Arrays.asList("javascript", id);
            if (!this.wasRendered(token1) && !this.wasRendered(token2)) {
                JavascriptUtils.writeJavascriptUrl(this.getResponse(), url, id);
                this.markRendered(token1);
                this.markRendered(token2);
            }
        }
    }

    public void renderJavascript(CharSequence javascript, String id) {
        List<Object> token;
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        if (!this.closed && !this.wasRendered(token = Arrays.asList(((Object)javascript).toString(), id))) {
            JavascriptUtils.writeJavascript(this.getResponse(), javascript, id);
            this.markRendered(token);
        }
    }

    public void renderString(CharSequence string) {
        String token;
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        if (!this.closed && !this.wasRendered(token = ((Object)string).toString())) {
            this.getResponse().write(string);
            this.markRendered(token);
        }
    }

    public final boolean wasRendered(Object object) {
        return this.rendered.contains(object);
    }

    public void renderOnDomReadyJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        if (!this.closed) {
            this.renderOnEventJavascript("window", "domready", javascript);
        }
    }

    public void renderOnLoadJavascript(String javascript) {
        if (javascript == null) {
            throw new IllegalArgumentException("javascript cannot be null");
        }
        if (!this.closed) {
            this.renderOnEventJavascript("window", "load", javascript);
        }
    }

    public void renderOnEventJavascript(String target, String event, String javascript) {
        List<Object> token;
        if (!this.closed && !this.wasRendered(token = Arrays.asList("javascript-event", target, event, javascript))) {
            this.renderJavascriptReference(WicketEventReference.INSTANCE);
            JavascriptUtils.writeJavascript(this.getResponse(), "Wicket.Event.add(" + target + ", \"" + event + "\", function(event) { " + javascript + ";});");
            this.markRendered(token);
        }
    }

    public void close() {
        this.closed = true;
    }

    public final Response getResponse() {
        return this.closed ? NullResponse.getInstance() : this.getRealResponse();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract Response getRealResponse();
}

