/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupResourceStream
implements IResourceStream,
IFixedLocationResourceStream {
    private static final long serialVersionUID = 1846489965076612828L;
    private final IResourceStream resourceStream;
    private final ContainerInfo containerInfo;
    private final String markupClassName;
    private String cacheKey;

    public MarkupResourceStream(IResourceStream resourceStream) {
        this.resourceStream = resourceStream;
        this.containerInfo = null;
        this.markupClassName = null;
        if (resourceStream == null) {
            throw new IllegalArgumentException("Parameter 'resourceStream' must not be null");
        }
    }

    public MarkupResourceStream(IResourceStream resourceStream, ContainerInfo containerInfo, Class<?> markupClass) {
        this.resourceStream = resourceStream;
        this.containerInfo = containerInfo;
        String string = this.markupClassName = markupClass == null ? null : markupClass.getName();
        if (resourceStream == null) {
            throw new IllegalArgumentException("Parameter 'resourceStream' must not be null");
        }
    }

    @Override
    public String locationAsString() {
        if (this.resourceStream instanceof IFixedLocationResourceStream) {
            return ((IFixedLocationResourceStream)((Object)this.resourceStream)).locationAsString();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.resourceStream.close();
    }

    @Override
    public String getContentType() {
        return this.resourceStream.getContentType();
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.resourceStream.getInputStream();
    }

    @Override
    public Locale getLocale() {
        return this.resourceStream.getLocale();
    }

    @Override
    public Time lastModifiedTime() {
        return this.resourceStream.lastModifiedTime();
    }

    @Override
    public long length() {
        return this.resourceStream.length();
    }

    @Override
    public void setLocale(Locale locale) {
        this.resourceStream.setLocale(locale);
    }

    public Class<? extends Component> getMarkupClass() {
        return Classes.resolveClass(this.markupClassName);
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public final String getCacheKey() {
        return this.cacheKey;
    }

    public final void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String toString() {
        return this.resourceStream.toString();
    }
}

