/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.lang.ref.WeakReference;
import java.util.Locale;
import org.apache.wicket.MarkupContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfo {
    private final WeakReference<Class<?>> containerClassRef;
    private final Locale locale;
    private final String style;
    private final String variation;
    private final String fileExtension;

    public ContainerInfo(MarkupContainer container) {
        this(container.getClass(), container.getLocale(), container.getStyle(), null, container.getMarkupType());
    }

    public ContainerInfo(Class<?> containerClass, Locale locale, String style, String variation, String fileExtension) {
        this.containerClassRef = new WeakReference(containerClass);
        this.locale = locale;
        this.style = style;
        this.variation = variation;
        this.fileExtension = fileExtension;
    }

    public Class<?> getContainerClass() {
        return (Class)this.containerClassRef.get();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getStyle() {
        return this.style;
    }

    public String getVariation() {
        return this.variation;
    }

    public String toString() {
        return ((Class)this.containerClassRef.get()).getName() + ":" + this.locale + ":" + this.style + ":" + this.fileExtension;
    }
}

