/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractAjaxTimerBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private Duration updateInterval;
    private boolean stopped = false;
    private boolean headRendered = false;

    public AbstractAjaxTimerBehavior(Duration updateInterval) {
        if (updateInterval == null || updateInterval.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("Invalid update interval");
        }
        this.updateInterval = updateInterval;
    }

    public final void stop() {
        this.stopped = true;
    }

    protected final void setUpdateInterval(Duration updateInterval) {
        if (updateInterval == null || updateInterval.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("Invalid update interval");
        }
        this.updateInterval = updateInterval;
    }

    public final Duration getUpdateInterval() {
        return this.updateInterval;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        WebRequest request = (WebRequest)RequestCycle.get().getRequest();
        if (!(this.stopped || this.headRendered && request.isAjax())) {
            this.headRendered = true;
            response.renderOnLoadJavascript(this.getJsTimeoutCall(this.updateInterval));
        }
    }

    protected final String getJsTimeoutCall(Duration updateInterval) {
        return "setTimeout(\"" + this.getCallbackScript() + "\", " + updateInterval.getMilliseconds() + ");";
    }

    protected CharSequence getCallbackScript() {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(this.onlyTargetActivePage()) + "'");
    }

    protected CharSequence getPreconditionScript() {
        String precondition = null;
        if (!(this.getComponent() instanceof Page)) {
            String componentId = this.getComponent().getMarkupId();
            precondition = "var c = Wicket.$('" + componentId + "'); return typeof(c) != 'undefined' && c != null";
        }
        return precondition;
    }

    protected boolean onlyTargetActivePage() {
        return true;
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onTimer(target);
        if (!this.stopped && this.isEnabled(this.getComponent())) {
            target.getHeaderResponse().renderOnLoadJavascript(this.getJsTimeoutCall(this.updateInterval));
        }
    }

    protected abstract void onTimer(AjaxRequestTarget var1);

    public final boolean isStopped() {
        return this.stopped;
    }
}

