/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.bounds;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class BoundsRestlet
extends GWCRestlet {
    private TileLayerDispatcher layerDispatcher;

    public void handle(Request request, Response response) {
        Method met = request.getMethod();
        try {
            if (!met.equals((Object)Method.GET)) {
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            this.doGet(request, response);
        }
        catch (RestletException re) {
            response.setEntity(re.getRepresentation());
            response.setStatus(re.getStatus());
        }
        catch (Exception e) {
            response.setEntity(e.getMessage() + " " + e.toString(), MediaType.TEXT_PLAIN);
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            e.printStackTrace();
        }
    }

    protected void doGet(Request req, Response resp) throws RestletException {
        String layerName = null;
        String srsStr = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        try {
            srsStr = URLDecoder.decode((String)req.getAttributes().get("srs"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        String type = (String)req.getAttributes().get("type");
        resp.setEntity(this.doGetInternal(layerName, srsStr, type));
    }

    protected Representation doGetInternal(String layerName, String gridSetId, String type) throws RestletException {
        TileLayer tl = BoundsRestlet.findTileLayer(layerName, this.layerDispatcher);
        if (tl == null) {
            throw new RestletException(layerName + " is not known", Status.CLIENT_ERROR_NOT_FOUND);
        }
        GridSubset grid = tl.getGridSubset(gridSetId);
        if (grid == null) {
            throw new RestletException(layerName + " does not support " + gridSetId, Status.CLIENT_ERROR_NOT_FOUND);
        }
        StringBuilder str = new StringBuilder();
        long[][] bounds = grid.getCoverages();
        if (type.equalsIgnoreCase("java")) {
            str.append("{");
            for (int i = 0; i < bounds.length; ++i) {
                str.append("{");
                for (int j = 0; j < bounds[i].length; ++j) {
                    str.append(bounds[i][j]);
                    if (j + 1 >= bounds[i].length) continue;
                    str.append(", ");
                }
                str.append("}");
                if (i + 1 >= bounds.length) continue;
                str.append(", ");
            }
            str.append("}");
            return new StringRepresentation((CharSequence)str.toString(), MediaType.TEXT_PLAIN);
        }
        throw new RestletException("Unknown or missing format extension : " + type, Status.CLIENT_ERROR_BAD_REQUEST);
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }
}

