/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.resources.NIOUtilities;

public class IndexedDbaseFileReader
extends DbaseFileReader {
    public void goTo(int recno) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            long newPosition = (long)this.header.getHeaderLength() + (long)this.header.getRecordLength() * (long)(recno - 1);
            if (this.useMemoryMappedBuffer) {
                if (newPosition < this.currentOffset || this.currentOffset + (long)this.buffer.limit() < newPosition + (long)this.header.getRecordLength()) {
                    NIOUtilities.clean((ByteBuffer)this.buffer);
                    FileChannel fc = (FileChannel)this.channel;
                    this.currentOffset = fc.size() > newPosition + Integer.MAX_VALUE ? newPosition : fc.size() - Integer.MAX_VALUE;
                    this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, this.currentOffset, Integer.MAX_VALUE);
                    this.buffer.position((int)(newPosition - this.currentOffset));
                } else {
                    this.buffer.position((int)(newPosition - this.currentOffset));
                }
            } else if (this.currentOffset <= newPosition && this.currentOffset + (long)this.buffer.limit() >= newPosition) {
                this.buffer.position((int)(newPosition - this.currentOffset));
            } else {
                FileChannel fc = (FileChannel)this.channel;
                fc.position(newPosition);
                this.currentOffset = newPosition;
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(0);
                this.fill(this.buffer, fc);
                this.buffer.position(0);
            }
        } else {
            throw new UnsupportedOperationException("Random access not enabled!");
        }
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles) throws IOException {
        this(shpFiles, false);
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles, boolean useMemoryMappedBuffer) throws IOException {
        super(shpFiles, useMemoryMappedBuffer, ShapefileDataStore.DEFAULT_STRING_CHARSET);
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles, boolean useMemoryMappedBuffer, Charset stringCharset) throws IOException {
        super(shpFiles, useMemoryMappedBuffer, stringCharset);
    }

    public boolean IsRandomAccessEnabled() {
        return this.randomAccessEnabled;
    }

    public static void main(String[] args) throws Exception {
        IndexedDbaseFileReader reader = new IndexedDbaseFileReader(new ShpFiles(args[0]), false);
        System.out.println(reader.getHeader());
        int r = 0;
        while (reader.hasNext()) {
            System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
        }
        reader.close();
    }
}

