/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGDALGridFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio.gdal");
    private final ImageReaderSpi spi;
    private static final String USE_MT = "USE_MULTITHREADING";
    public static final DefaultParameterDescriptor<Boolean> USE_MULTITHREADING = new DefaultParameterDescriptor("USE_MULTITHREADING", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);

    protected BaseGDALGridFormat(ImageReaderSpi spi) {
        this.spi = spi;
        this.setInfo();
    }

    protected abstract void setInfo();

    @Override
    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    @Override
    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("This plugin does not support writing parameters");
    }

    @Override
    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    @Override
    public boolean accepts(Object input, Hints hints) {
        try {
            return this.spi.canDecodeInput(input);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
    }

    protected static ParameterGroup getDefaultParameterGroup(Map<String, String> mInfo) {
        return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, USE_JAI_IMAGEREAD, USE_MULTITHREADING, SUGGESTED_TILE_SIZE}));
    }

    @Override
    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }
}

