/*
 * Decompiled with CFR 0.152.
 */
package jaitools.numeric;

public class DoubleComparison {
    public static final double TOL = 1.0E-8;

    public static boolean dzero(double x) {
        return Math.abs(x) < 1.0E-8;
    }

    public static boolean dzero(double x, double tol) {
        if (tol < 1.0E-8) {
            return DoubleComparison.dzero(x);
        }
        return Math.abs(x) < tol;
    }

    public static int dcomp(double x1, double x2) {
        if (DoubleComparison.dzero(x1 - x2)) {
            return 0;
        }
        return Double.compare(x1, x2);
    }

    public static int dcomp(double x1, double x2, double tol) {
        if (tol < 1.0E-8) {
            return DoubleComparison.dcomp(x1, x2);
        }
        if (DoubleComparison.dzero(x1 - x2, tol)) {
            return 0;
        }
        return Double.compare(x1, x2);
    }

    public static boolean dequal(double x1, double x2) {
        return DoubleComparison.dzero(x1 - x2);
    }

    public static boolean dequal(double x1, double x2, double tol) {
        return DoubleComparison.dzero(x1 - x2, tol);
    }

    public static int toInt(double x) {
        int sign = DoubleComparison.dcomp(x, 0.0);
        if (sign > 0) {
            return (int)(x + 0.5);
        }
        if (sign < 0) {
            return (int)(x - 0.5);
        }
        return 0;
    }
}

