/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import jaitools.jts.AbstractSmoother;
import java.util.ArrayList;

public class LineSmoother
extends AbstractSmoother {
    public LineSmoother() {
        super(new GeometryFactory());
    }

    public LineSmoother(GeometryFactory geomFactory) {
        super(geomFactory);
    }

    private Coordinate[][] getControlPoints(Coordinate[] coords, double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be a value between 0 and 1 inclusive");
        }
        int N = coords.length;
        Coordinate[][] ctrl = new Coordinate[N][2];
        Coordinate[] v = new Coordinate[3];
        Coordinate[] mid = new Coordinate[]{new Coordinate(), new Coordinate()};
        Coordinate anchor = new Coordinate();
        double[] vdist = new double[2];
        v[1] = new Coordinate(2.0 * coords[0].x - coords[1].x, 2.0 * coords[0].y - coords[1].y);
        v[2] = coords[0];
        Coordinate vN = new Coordinate(2.0 * coords[N - 1].x - coords[N - 2].x, 2.0 * coords[N - 1].y - coords[N - 2].y);
        mid[1].x = (v[1].x + v[2].x) / 2.0;
        mid[1].y = (v[1].y + v[2].y) / 2.0;
        vdist[1] = v[1].distance(v[2]);
        for (int i = 0; i < N; ++i) {
            v[0] = v[1];
            v[1] = v[2];
            v[2] = i < N - 1 ? coords[i + 1] : vN;
            mid[0].x = mid[1].x;
            mid[0].y = mid[1].y;
            mid[1].x = (v[1].x + v[2].x) / 2.0;
            mid[1].y = (v[1].y + v[2].y) / 2.0;
            vdist[0] = vdist[1];
            vdist[1] = v[1].distance(v[2]);
            double p = vdist[0] / (vdist[0] + vdist[1]);
            anchor.x = mid[0].x + p * (mid[1].x - mid[0].x);
            anchor.y = mid[0].y + p * (mid[1].y - mid[0].y);
            double xdelta = anchor.x - v[1].x;
            double ydelta = anchor.y - v[1].y;
            ctrl[i][0] = new Coordinate(alpha * (v[1].x - mid[0].x + xdelta) + mid[0].x - xdelta, alpha * (v[1].y - mid[0].y + ydelta) + mid[0].y - ydelta);
            ctrl[i][1] = new Coordinate(alpha * (v[1].x - mid[1].x + xdelta) + mid[1].x - xdelta, alpha * (v[1].y - mid[1].y + ydelta) + mid[1].y - ydelta);
        }
        return ctrl;
    }

    public LineString smooth(LineString ls, double alpha) {
        Coordinate[] coords = ls.getCoordinates();
        Coordinate[][] controlPoints = this.getControlPoints(coords, alpha);
        int N = coords.length;
        ArrayList<Coordinate> smoothCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < N - 1; ++i) {
            double dist = coords[i].distance(coords[i + 1]);
            if (dist < this.control.getMinLength()) {
                smoothCoords.add(new Coordinate(coords[i]));
                continue;
            }
            int smoothN = this.control.getNumVertices(dist);
            Coordinate[] segment = this.cubicBezier(coords[i], coords[i + 1], controlPoints[i][1], controlPoints[i + 1][0], smoothN);
            int copyN = i < N - 1 ? segment.length - 1 : segment.length;
            for (int k = 0; k < copyN; ++k) {
                smoothCoords.add(segment[k]);
            }
        }
        smoothCoords.add(coords[N - 1]);
        return this.geomFactory.createLineString(smoothCoords.toArray(new Coordinate[0]));
    }
}

