/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicNode
extends BasicGraphable
implements Node {
    private transient ArrayList m_edges = new ArrayList();

    public void add(Edge e) {
        this.m_edges.add(e);
    }

    public void remove(Edge e) {
        this.m_edges.remove(e);
    }

    public int getDegree() {
        int degree = 0;
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge e = (Edge)this.m_edges.get(i);
            if (e.getNodeA().equals(this)) {
                ++degree;
            }
            if (!e.getNodeB().equals(this)) continue;
            ++degree;
        }
        return degree;
    }

    public Edge getEdge(Node other) {
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge e = (Edge)this.m_edges.get(i);
            if ((!e.getNodeA().equals(this) || !e.getNodeB().equals(other)) && (!e.getNodeA().equals(other) || !e.getNodeB().equals(this))) continue;
            return e;
        }
        return null;
    }

    public List getEdges(Node other) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge e = (Edge)this.m_edges.get(i);
            if ((!e.getNodeA().equals(this) || !e.getNodeB().equals(other)) && (!e.getNodeA().equals(other) || !e.getNodeB().equals(this))) continue;
            edges.add(e);
        }
        return edges;
    }

    public List getEdges() {
        return this.m_edges;
    }

    public Iterator getRelated() {
        ArrayList<Node> related = new ArrayList<Node>(this.m_edges.size());
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge e = (Edge)this.m_edges.get(i);
            related.add(e.getOtherNode(this));
        }
        return related.iterator();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_edges = new ArrayList();
    }
}

