/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation.generated;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.wicket.util.template.CssTemplate;
import org.apache.wicket.util.template.JavaScriptTemplate;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.tuckey.web.filters.validation.LineIssue;
import org.tuckey.web.filters.validation.ValidationDoctype;
import org.tuckey.web.filters.validation.ValidationHandler;
import org.tuckey.web.filters.validation.utils.StringEscapeUtils;
import org.tuckey.web.filters.validation.utils.StringUtils;

public class GeneratedValidationReport {
    public ValidationHandler validationHandler;

    public String getHeadMarkup() {
        CssTemplate cssTemplate = new CssTemplate((TextTemplate)new PackagedTextTemplate(GeneratedValidationReport.class, "GeneratedValidationReport.css"));
        String css = cssTemplate.asString();
        JavaScriptTemplate jsTemplate = new JavaScriptTemplate((TextTemplate)new PackagedTextTemplate(GeneratedValidationReport.class, "GeneratedValidationReport.js"));
        String js = jsTemplate.asString();
        return css + "\n" + js;
    }

    public String getBodyMarkup() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.writeReportDiv(pw);
        this.writeControlPanel(pw);
        return sw.toString();
    }

    private void writeReportDiv(PrintWriter pw) {
        pw.println("<div id=\"validationFilterReport\">");
        this.writeHeader(pw);
        if (!this.validationHandler.isValid()) {
            this.writeErrorsAndSource(pw);
        }
        this.writeFooter(pw);
        pw.println("</div>");
    }

    private void writeHeader(PrintWriter pw) {
        pw.println("    <h1>ValidationFilter 0.6</h1>");
        pw.println();
        pw.println("<p>");
        if (this.validationHandler.isValid()) {
            pw.write("This document is valid ");
        } else {
            pw.write("This document is <b class=\"fat\">NOT</b> valid ");
        }
        String doctypeText = this.getDoctypeW3CUrlMarkup();
        pw.print(doctypeText);
        pw.write(" markup.");
        pw.println("</p>");
    }

    private void writeErrorsAndSource(PrintWriter pw) {
        String sourceLine;
        List errors = this.validationHandler.getErrors();
        String[] sourceLines = this.validationHandler.getSourceAsArrayOfLines();
        pw.write("<ul>");
        for (int i = 0; i < errors.size(); ++i) {
            LineIssue lineIssue = (LineIssue)errors.get(i);
            String goToLine = "";
            if (lineIssue.getLineNumber() > 0) {
                goToLine = " <a href=\"#l" + lineIssue.getLineNumber() + "\">Line " + lineIssue.getLineNumber() + "</a>";
            }
            pw.write("<li>");
            pw.write(goToLine);
            pw.write(" <span class=\"");
            pw.write(lineIssue.getType());
            pw.write("\">\n                ");
            pw.write(lineIssue.getTypeTitle());
            pw.write("</span>: (");
            pw.write("" + lineIssue.getLineNumber());
            pw.write(", ");
            pw.write("" + lineIssue.getColumnNumber());
            pw.write(") ");
            pw.write(lineIssue.getMessage());
            if (lineIssue.getLineNumber() <= 1 || lineIssue.getLineNumber() > sourceLines.length) continue;
            sourceLine = sourceLines[lineIssue.getLineNumber() - 1];
            pw.write("<pre>");
            pw.write(StringEscapeUtils.escapeHtml(sourceLine));
            pw.write("\n");
            pw.write(StringUtils.repeat(" ", lineIssue.getColumnNumber() - 1));
            pw.write("<span class=\"colInd\">^</span></pre></li>");
        }
        pw.write("</ul>\n\n    ");
        int padBy = (sourceLines.length + "").length();
        pw.write("</h2>\n    <pre>\n");
        for (int i = 0; i < sourceLines.length; ++i) {
            int lineNumber = i + 1;
            sourceLine = StringEscapeUtils.escapeHtml(sourceLines[i]);
            String lineInd = StringUtils.repeat("&nbsp;", padBy - (lineNumber + "").length()) + lineNumber;
            LineIssue currentLineIssue = null;
            for (int j = 0; j < errors.size(); ++j) {
                LineIssue lineIssue = (LineIssue)errors.get(j);
                if (lineIssue.getLineNumber() != lineNumber) continue;
                currentLineIssue = lineIssue;
            }
            pw.write("<a name=\"l");
            pw.write(String.valueOf(lineNumber));
            pw.write("\" /><span class=\"lin\"\n                    ");
            pw.write(i == 0 ? " style=\"border-top: 1px solid #c0c0c0;\"" : "");
            pw.write("\n                    ");
            pw.write(i == sourceLines.length - 1 ? " style=\"border-bottom: 1px solid #c0c0c0;\"" : "");
            pw.write("\n            >&nbsp;");
            pw.write(lineInd);
            pw.write("&nbsp;</span>&nbsp;");
            if (currentLineIssue != null) {
                String msg = currentLineIssue.getMessage();
                if (msg.indexOf("\"") != -1 || msg.indexOf("<") != -1 || msg.indexOf(">") != -1) {
                    msg = StringEscapeUtils.escapeHtml(currentLineIssue.getMessage());
                }
                pw.write("<span class=\"");
                pw.write(currentLineIssue.getType());
                pw.write("\"\n                        title=\"");
                pw.write(currentLineIssue.getTypeTitle() + ": (" + currentLineIssue.getLineNumber() + ", " + currentLineIssue.getColumnNumber() + ") " + msg);
                pw.write("\">");
                pw.write(sourceLine.trim());
                pw.write("</span>");
            } else {
                pw.write(sourceLine);
            }
            pw.write("\n");
        }
        pw.write("\n    </pre>");
    }

    private String getDoctypeW3CUrlMarkup() {
        String doctypeText = "";
        ValidationDoctype doctype = this.validationHandler.getDoctype();
        doctypeText = doctype != null ? ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(doctype.getPublicId()) ? "<a href=\"http://www.w3.org/TR/xhtml1/\">XHTML 1.0 Transitional</a>" : ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(doctype.getPublicId()) ? "<a href=\"http://www.w3.org/TR/xhtml1/\">XHTML 1.0 Strict</a>" : ("-//W3C//DTD XHTML Basic 1.0//EN".equals(doctype.getPublicId()) ? "<a href=\"http://www.w3.org/TR/xhtml-basic/\">XHTML 1.0 Basic</a>" : doctype.getPublicId()))) : "No doctype information found";
        return doctypeText;
    }

    private void writeFooter(PrintWriter pw) {
        pw.println("<h4>");
        pw.println("    Generated by <a href=\"http://tuckey.org/validation/\">Validation Filter</a>");
        pw.println("    <br />" + new SimpleDateFormat().format(new Date()));
        pw.println("</h4>");
    }

    private void writeControlPanel(PrintWriter pw) {
        pw.println("<div id=\"validationFilterReportControl\">");
        pw.println("    <b>XHTML errors - <a href=\"#\" onclick=\"vfrToggle();return false;\">toggle display</a></b> -");
        pw.println("    <a href=\"#\" onclick=\"vfrHide();return false;\">close</a>");
        pw.println("</div>");
    }
}

