/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Transaction;
import org.geotools.util.logging.Logging;

public class JDBCUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");

    private JDBCUtils() {
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC ResultSet";
                LOGGER.log(Level.WARNING, msg, e);
            }
            catch (Exception e) {
                String string = "Error closing JDBC ResultSet";
            }
        }
    }

    public static void close(Connection conn, Transaction transaction, SQLException sqlException) {
        if (conn == null) {
            return;
        }
        if (transaction != null && transaction != Transaction.AUTO_COMMIT) {
            if (sqlException != null) {
                try {
                    transaction.rollback();
                }
                catch (IOException e) {
                    String msg = "Error rolling back transaction in responseto connection error. We are in an inconsistent state";
                    LOGGER.log(Level.SEVERE, msg, e);
                }
            }
            return;
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Connection";
            LOGGER.log(Level.WARNING, msg, e);
        }
    }
}

