/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class GWCVars {
    private static final Log log = LogFactory.getLog(GWCVars.class);
    public static final int CACHE_VALUE_UNSET = 0;
    public static final int CACHE_DISABLE_CACHE = -1;
    public static final int CACHE_NEVER_EXPIRE = -2;
    public static final int CACHE_USE_WMS_BACKEND_VALUE = -4;

    public static String findEnvVar(ApplicationContext context, String varStr) {
        ServletContext serlvCtx = null;
        if (context instanceof WebApplicationContext) {
            serlvCtx = ((WebApplicationContext)context).getServletContext();
        }
        String[] typeStrs = new String[]{"Java environment variable ", "servlet context parameter ", "system environment variable "};
        String value = null;
        for (int j = 0; j < typeStrs.length && value == null; ++j) {
            String typeStr = typeStrs[j];
            switch (j) {
                case 0: {
                    value = System.getProperty(varStr);
                    break;
                }
                case 1: {
                    if (serlvCtx == null) break;
                    value = serlvCtx.getInitParameter(varStr);
                    break;
                }
                case 2: {
                    value = System.getenv(varStr);
                }
            }
            if (value == null) continue;
            if (varStr.equals("GWC_METASTORE_PASSWORD")) {
                log.info((Object)("Found " + typeStr + " for " + varStr + " set to <hidden>"));
                continue;
            }
            log.info((Object)("Found " + typeStr + " for " + varStr + " set to " + value));
        }
        return value;
    }
}

