/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;

public class FilePathFilter
implements FilenameFilter {
    String gridSetPrefix = null;
    String mimeExtension = null;
    TileRange tr;

    public FilePathFilter(TileRange trObj) throws StorageException {
        this.tr = trObj;
        if (this.tr.gridSetId == null) {
            throw new StorageException("Specifying the grid set id is currently mandatory.");
        }
        this.gridSetPrefix = FilePathGenerator.filteredGridSetId(this.tr.gridSetId);
        if (this.tr.mimeType != null) {
            this.mimeExtension = this.tr.mimeType.getFileExtension();
        }
    }

    public boolean accept(File dir, String name) {
        boolean ret = name.startsWith(this.gridSetPrefix) ? this.acceptZoomLevelDir(name) : (name.contains(".") ? this.acceptFileName(dir, name) : this.acceptIntermediateDir(name));
        return ret;
    }

    private boolean acceptZoomLevelDir(String name) {
        int tmp;
        if (!name.startsWith(this.gridSetPrefix)) {
            return false;
        }
        return this.tr.zoomStart == -1 && this.tr.zoomStop == -1 || (tmp = FilePathGenerator.findZoomLevel(name)) >= this.tr.zoomStart && tmp <= this.tr.zoomStop;
    }

    private boolean acceptIntermediateDir(String name) {
        return true;
    }

    private boolean acceptFileName(File dir, String name) {
        String[] parts = name.split("\\.");
        if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
            return false;
        }
        if (this.tr.rangeBounds != null) {
            String[] coords = parts[0].split("_");
            int zoomLevel = FilePathGenerator.findZoomLevel(dir.getParentFile().getName());
            long x = Long.parseLong(coords[0]);
            long y = Long.parseLong(coords[1]);
            boolean contains = this.tr.contains(x, y, zoomLevel);
            return contains;
        }
        return true;
    }
}

