/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Map;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileRange {
    public final String layerName;
    public final String gridSetId;
    public final int zoomStart;
    public final int zoomStop;
    public final long[][] rangeBounds;
    public final MimeType mimeType;
    public final Map<String, String> parameters;
    private Long parametersId;

    public TileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, long[][] rangeBounds, MimeType mimeType, String parameters) {
        this(layerName, gridSetId, zoomStart, zoomStop, rangeBounds, mimeType, ServletUtils.queryStringToMap(parameters));
    }

    public TileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, long[][] rangeBounds, MimeType mimeType, Map<String, String> parameters) {
        this.layerName = layerName;
        this.gridSetId = gridSetId;
        this.rangeBounds = rangeBounds;
        this.zoomStart = zoomStart;
        this.zoomStop = zoomStop;
        this.mimeType = mimeType;
        this.parameters = parameters;
        this.parametersId = null;
    }

    public boolean contains(long[] idx) {
        return this.contains(idx[0], idx[1], (int)idx[2]);
    }

    public boolean contains(long x, long y, int z) {
        long[] rB;
        return z >= this.zoomStart && z <= this.zoomStop && (rB = this.rangeBounds[z])[0] <= x && rB[2] >= x && rB[1] <= y && rB[3] >= y;
    }

    public void setParametersId(long parametersId) {
        this.parametersId = parametersId;
    }

    public Long getParametersId() {
        return this.parametersId;
    }
}

