/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.MTSeeder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeederThreadPoolExecutor
extends ThreadPoolExecutor
implements DisposableBean {
    private static final Log log = LogFactory.getLog(SeederThreadPoolExecutor.class);
    private static final ThreadFactory tf = new CustomizableThreadFactory("GWC Seeder Thread-");
    long currentId = 0L;
    TreeMap<Long, GWCTask> currentPool = new TreeMap();

    public SeederThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        SeederThreadPoolExecutor seederThreadPoolExecutor = this;
        synchronized (seederThreadPoolExecutor) {
            GWCTask task = this.extractGWCTask(r);
            if (task != null) {
                Long taskId = this.getNextId();
                task.setTaskId(taskId);
                this.currentPool.put(taskId, task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            SeederThreadPoolExecutor seederThreadPoolExecutor = this;
            synchronized (seederThreadPoolExecutor) {
                GWCTask task = this.extractGWCTask(r);
                if (task != null) {
                    this.currentPool.remove(task.getTaskId());
                }
            }
        }
        finally {
            super.afterExecute(r, t);
        }
    }

    private GWCTask extractGWCTask(Runnable r) {
        FutureTask fT = null;
        if (!(r instanceof FutureTask)) {
            return null;
        }
        fT = (FutureTask)r;
        GWCTask task = null;
        Class<?> c = fT.getClass();
        try {
            Field sync = c.getDeclaredField("sync");
            sync.setAccessible(true);
            Object obj = sync.get(fT);
            c = obj.getClass();
            Field callable = c.getDeclaredField("callable");
            callable.setAccessible(true);
            MTSeeder mts = (MTSeeder)callable.get(obj);
            task = mts.task;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return task;
    }

    public boolean terminateGWCTask(long id) {
        GWCTask task = this.currentPool.get(id);
        if (task != null && GWCTask.TYPE.TRUNCATE != task.getType()) {
            task.terminateNicely();
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<Long, GWCTask>> getRunningTasksIterator() {
        return this.currentPool.entrySet().iterator();
    }

    private long getNextId() {
        long ret = this.currentId++;
        return ret;
    }

    public void destroy() throws Exception {
        log.info((Object)"Initiating shut down for running and pending seed tasks...");
        this.shutdownNow();
        while (!this.isTerminated()) {
            log.debug((Object)"Waiting for pending tasks to terminate....");
            Thread.sleep(500L);
        }
        log.info((Object)"Seeder thread pool executor shut down complete.");
    }
}

