/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;

public class LayerListenerList {
    private List<TileLayerListener> listeners = Collections.emptyList();

    public void addListener(TileLayerListener listener) {
        if (listener != null) {
            ArrayList<TileLayerListener> tmp = new ArrayList<TileLayerListener>(this.listeners.size() + 1);
            tmp.addAll(this.listeners);
            tmp.add(listener);
            this.listeners = tmp;
        }
    }

    public boolean removeListener(TileLayerListener listener) {
        return this.listeners.remove(listener);
    }

    public void sendTileRequested(TileLayer layer, ConveyorTile tile) {
        if (this.listeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TileLayerListener listener = this.listeners.get(i);
            listener.tileRequested(layer, tile);
        }
    }
}

