/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundingBox {
    private static Log log = LogFactory.getLog(BoundingBox.class);
    private static String DELIMITER = ",";
    private static double EQUALITYTHRESHOLD = 0.03;
    public static final BoundingBox WORLD4326 = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    public static final BoundingBox WORLD3857 = new BoundingBox(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
    private double[] coords = new double[4];

    public BoundingBox(BoundingBox bbox) {
        this.coords[0] = bbox.coords[0];
        this.coords[1] = bbox.coords[1];
        this.coords[2] = bbox.coords[2];
        this.coords[3] = bbox.coords[3];
    }

    public BoundingBox(String BBOX) {
        this.setFromBBOXString(BBOX, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BoundingBox(String[] BBOX) {
        this.setFromStringArray(BBOX);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BoundingBox(double minx, double miny, double maxx, double maxy) {
        this.coords[0] = minx;
        this.coords[1] = miny;
        this.coords[2] = maxx;
        this.coords[3] = maxy;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public double getMinX() {
        return this.coords[0];
    }

    public void setMinX(double minx) {
        this.coords[0] = minx;
    }

    public double getMinY() {
        return this.coords[1];
    }

    public void setMinY(double miny) {
        this.coords[1] = miny;
    }

    public double getMaxX() {
        return this.coords[2];
    }

    public void setMaxX(double maxx) {
        this.coords[2] = maxx;
    }

    public double getMaxY() {
        return this.coords[3];
    }

    public void setMaxY(double maxy) {
        this.coords[3] = maxy;
    }

    public double[] getCoords() {
        return (double[])this.coords.clone();
    }

    public double getWidth() {
        return this.coords[2] - this.coords[0];
    }

    public double getHeight() {
        return this.coords[3] - this.coords[1];
    }

    public void setFromStringArray(String[] BBOX) {
        this.setFromStringArray(BBOX, 0);
    }

    public void setFromStringArray(String[] BBOX, int recWatch) {
        if (BBOX.length == 4) {
            this.coords[0] = Double.parseDouble(BBOX[0]);
            this.coords[1] = Double.parseDouble(BBOX[1]);
            this.coords[2] = Double.parseDouble(BBOX[2]);
            this.coords[3] = Double.parseDouble(BBOX[3]);
        } else if (recWatch < 4) {
            this.setFromBBOXString(BBOX[0], recWatch);
        } else {
            log.error((Object)("Doesnt understand " + Arrays.toString(BBOX)));
        }
    }

    public void setFromBBOXString(String BBOX, int recWatch) {
        String[] tokens = BBOX.split(DELIMITER);
        this.setFromStringArray(tokens, recWatch + 1);
    }

    public String getReadableString() {
        return "Min X: " + this.coords[0] + " Min Y: " + this.coords[1] + " Max X: " + this.coords[2] + " Max Y: " + this.coords[3];
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(40);
        buff.append(Double.toString(this.coords[0]));
        buff.append(',');
        buff.append(Double.toString(this.coords[1]));
        buff.append(',');
        buff.append(Double.toString(this.coords[2]));
        buff.append(',');
        buff.append(Double.toString(this.coords[3]));
        return buff.toString();
    }

    public String toKMLLatLonBox() {
        return "<LatLonBox><north>" + Double.toString(this.coords[3]) + "</north>" + "<south>" + Double.toString(this.coords[1]) + "</south>" + "<east>" + Double.toString(this.coords[2]) + "</east>" + "<west>" + Double.toString(this.coords[0]) + "</west>" + "</LatLonBox>";
    }

    public String toKMLLatLonAltBox() {
        return "<LatLonAltBox><north>" + Double.toString(this.coords[3]) + "</north>" + "<south>" + Double.toString(this.coords[1]) + "</south>" + "<east>" + Double.toString(this.coords[2]) + "</east>" + "<west>" + Double.toString(this.coords[0]) + "</west>" + "</LatLonAltBox>";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            BoundingBox other = (BoundingBox)obj;
            return this.equals(other, EQUALITYTHRESHOLD);
        }
        return false;
    }

    public boolean equals(BoundingBox other, double threshold) {
        boolean result = true;
        for (int i = 0; i < 4 && result; ++i) {
            result = Math.abs(this.coords[i]) < threshold && Math.abs(other.coords[i]) < threshold || (this.coords[i] - other.coords[i]) / (this.coords[i] + other.coords[i]) < threshold;
        }
        return result;
    }

    public boolean contains(BoundingBox other) {
        return this.coords[0] - EQUALITYTHRESHOLD <= other.coords[0] && this.coords[1] - EQUALITYTHRESHOLD <= other.coords[1] && this.coords[2] + EQUALITYTHRESHOLD >= other.coords[2] && this.coords[3] + EQUALITYTHRESHOLD >= other.coords[3];
    }

    public boolean isSane() {
        return this.coords[0] < this.coords[2] && this.coords[1] < this.coords[3];
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.coords[0]) ^ Float.floatToIntBits((float)this.coords[1]);
    }

    public boolean intersects(BoundingBox other) {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width <= 0.0 || height <= 0.0 || other.getWidth() <= 0.0 || other.getHeight() <= 0.0) {
            return false;
        }
        return other.coords[0] + other.getWidth() > this.coords[0] && other.coords[1] + other.getHeight() > this.coords[1] && other.coords[0] < this.coords[0] + width && other.coords[1] < this.coords[1] + height;
    }

    public static BoundingBox intersection(BoundingBox bboxA, BoundingBox bboxB) {
        BoundingBox retBbox = new BoundingBox(0.0, 0.0, 0.0, 0.0);
        if (bboxA.intersects(bboxB)) {
            int i;
            for (i = 0; i < 2; ++i) {
                retBbox.coords[i] = bboxA.coords[i] > bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
            }
            for (i = 2; i < 4; ++i) {
                retBbox.coords[i] = bboxA.coords[i] < bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
            }
        }
        return retBbox;
    }

    public void scale(double xFactor, double yFactor) {
        double x = this.coords[2] - this.coords[0];
        double xdiff = (x * xFactor - x) / 2.0;
        double y = this.coords[3] - this.coords[1];
        double ydiff = (y * yFactor - y) / 2.0;
        this.coords[0] = this.coords[0] - xdiff;
        this.coords[1] = this.coords[1] - ydiff;
        this.coords[2] = this.coords[2] + xdiff;
        this.coords[3] = this.coords[3] + ydiff;
    }

    public void scale(double factor) {
        this.scale(factor, factor);
    }
}

