/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalogbuilder;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.SwingUtilities;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.console.CommandLine;
import org.geotools.console.Option;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

public class CatalogBuilder
implements Runnable {
    private static final double RESOLUTION_TOLERANCE_FACTOR = 0.01;
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    private int numFiles;
    private List<ProcessingEventListener> notificationListeners = Collections.synchronizedList(new ArrayList());
    private boolean sendDelayedMessages = false;
    private volatile boolean stop = false;
    private MosaicConfigurationBean mosaicConfiguration;
    private GeometryFactory geomFactory;
    private GranuleCatalog catalog;
    private int numberOfProcessedFiles;
    private boolean mustConvertToRGB = false;
    private int fileIndex = 0;
    private ColorModel defaultCM = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private byte[][] defaultPalette = null;
    private CatalogBuilderConfiguration runConfiguration;
    private ImageReaderSpi cachedSPI;
    private List<PropertiesCollector> propertiesCollectors;
    private SampleModel defaultSM;
    private ReferencedEnvelope imposedBBox;

    public void run() {
        try {
            IOFileFilter finalFilter = this.createGranuleFilterRules();
            this.numFiles = 0;
            for (String indexingDirectory : this.runConfiguration.getIndexingDirectories()) {
                File directoryToScan = new File(indexingDirectory);
                Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)(this.runConfiguration.isRecursive() ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
                this.numFiles += files.size();
            }
            if (this.numFiles > 0) {
                List<String> indexingDirectories = this.runConfiguration.getIndexingDirectories();
                for (String indexingDirectory : indexingDirectories) {
                    CatalogBuilderDirectoryWalker walker = new CatalogBuilderDirectoryWalker(new File(indexingDirectory), (FileFilter)finalFilter);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private IOFileFilter createGranuleFilterRules() {
        WildcardFileFilter specialWildCardFileFilter = new WildcardFileFilter(this.runConfiguration.getWildcard(), IOCase.INSENSITIVE);
        IOFileFilter dirFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)HiddenFileFilter.VISIBLE);
        IOFileFilter fileFilter = Utils.excludeFilters(FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)specialWildCardFileFilter, (IOFileFilter)HiddenFileFilter.VISIBLE))), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"svn-base"));
        Set extensions = WorldImageFormat.getWorldExtension((String)"png");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"gif");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"jpg");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"tiff");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"bmp");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"sdw")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"aux")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"svn")));
        IOFileFilter finalFilter = FileFilterUtils.orFileFilter((IOFileFilter)dirFilter, (IOFileFilter)fileFilter);
        return finalFilter;
    }

    public CatalogBuilder(CatalogBuilderConfiguration configuration) {
        Utilities.ensureNonNull((String)"runConfiguration", (Object)configuration);
        configuration.check();
        this.runConfiguration = new CatalogBuilderConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProcessingEventListener(ProcessingEventListener listener) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.add(listener);
        }
    }

    public void reset() {
        this.removeAllProcessingEventListeners();
        this.stop = false;
        this.closeIndexObjects();
        this.defaultCM = null;
        this.defaultCRS = null;
        this.defaultPalette = null;
        this.fileIndex = 0;
        this.numberOfProcessedFiles = 0;
        this.runConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Level level, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            ProcessingEvent evt = new ProcessingEvent(this, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.fireException(Utils.getMessageFromException(ex), -1.0, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(String string, double percentage, Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(string);
            ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public boolean isSendDelayedMessages() {
        return this.sendDelayedMessages;
    }

    public void setSendDelayedMessages(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProcessingEventListeners() {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessingEventListener(ProcessingEventListener listener) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.remove(listener);
        }
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void indexingPreamble() throws IOException {
        block10: {
            PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
            this.geomFactory = new GeometryFactory(precMod);
            File parent = new File(this.runConfiguration.getRootMosaicDirectory());
            File datastoreProperties = new File(parent, "datastore.properties");
            if (Utils.checkFileReadable(datastoreProperties)) {
                Properties properties = Utils.loadPropertiesFromURL(DataUtilities.fileToURL((File)datastoreProperties));
                if (properties == null) {
                    throw new IOException();
                }
                String SPIClass = properties.getProperty("SPI");
                try {
                    DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                    Map<String, Serializable> params = Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
                    this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, spi);
                }
                catch (ClassNotFoundException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (InstantiationException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (IllegalAccessException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
            } else {
                URL file = new File(parent, this.runConfiguration.getIndexName() + ".shp").toURI().toURL();
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put(ShapefileDataStoreFactory.URLP.key, file);
                if (file.getProtocol().equalsIgnoreCase("file")) {
                    params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
                }
                params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.TRUE);
                this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, Utils.SHAPE_SPI);
            }
            this.mosaicConfiguration = new MosaicConfigurationBean();
            this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
            String bbox = this.runConfiguration.getEnvelope2D();
            try {
                this.imposedBBox = Utils.parseEnvelope(bbox);
            }
            catch (Exception e) {
                this.imposedBBox = null;
                if (!LOGGER.isLoggable(Level.WARNING)) break block10;
                LOGGER.log(Level.WARNING, "Unable to parse imposed bbox", e);
            }
        }
        this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
        this.loadPropertyCollectors();
    }

    private void loadPropertyCollectors() {
        String pcConfig = this.runConfiguration.getPropertyCollectors();
        if (pcConfig != null && pcConfig.length() > 0) {
            String[] pcsDefs;
            Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
            ArrayList<PropertiesCollector> pcs = new ArrayList<PropertiesCollector>();
            for (String pcDef : pcsDefs = pcConfig.split(",")) {
                int squareLPos = pcDef.indexOf("[");
                int squareRPos = pcDef.indexOf("]");
                int squareRPosLast = pcDef.lastIndexOf("]");
                int roundLPos = pcDef.indexOf("(");
                int roundRPos = pcDef.indexOf(")");
                int roundRPosLast = pcDef.lastIndexOf(")");
                if (squareRPos != squareRPosLast || squareLPos == -1 || squareRPos == -1 || squareLPos == 0 || roundRPos != roundRPosLast || roundLPos == -1 || roundRPos == -1 || roundLPos == 0 || roundLPos != squareRPos + 1 || roundRPos != pcDef.length() - 1) continue;
                String name = pcDef.substring(0, squareLPos);
                PropertiesCollectorSPI selectedSPI = null;
                for (PropertiesCollectorSPI spi : pcSPIs) {
                    if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(name)) continue;
                    selectedSPI = spi;
                    break;
                }
                if (selectedSPI == null) continue;
                String config = squareLPos < squareRPos ? pcDef.substring(squareLPos + 1, squareRPos) : "";
                File configFile = new File(this.runConfiguration.getRootMosaicDirectory(), config + ".properties");
                if (!Utils.checkFileReadable(configFile)) continue;
                String[] propertyNames = pcDef.substring(roundLPos + 1, roundRPos).split(",");
                PropertiesCollector pc = selectedSPI.create(configFile, Arrays.asList(propertyNames));
                if (pc != null) {
                    pcs.add(pc);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to create PropertyCollector from config file:" + configFile);
            }
            this.propertiesCollectors = pcs;
        }
    }

    private void indexingPostamble() throws IOException {
        this.closeIndexObjects();
        this.createSampleImage();
        if (this.numberOfProcessedFiles > 0) {
            String runtimeAttribute;
            String elevationAttribute;
            this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
            this.mosaicConfiguration.setExpandToRGB(this.mustConvertToRGB);
            this.mosaicConfiguration.setAbsolutePath(this.runConfiguration.isAbsolute());
            this.mosaicConfiguration.setLocationAttribute(this.runConfiguration.getLocationAttribute());
            this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
            String timeAttribute = this.runConfiguration.getTimeAttribute();
            if (timeAttribute != null) {
                this.mosaicConfiguration.setTimeAttribute(this.runConfiguration.getTimeAttribute());
            }
            if ((elevationAttribute = this.runConfiguration.getElevationAttribute()) != null) {
                this.mosaicConfiguration.setElevationAttribute(this.runConfiguration.getElevationAttribute());
            }
            if ((runtimeAttribute = this.runConfiguration.getRuntimeAttribute()) != null) {
                this.mosaicConfiguration.setRuntimeAttribute(this.runConfiguration.getRuntimeAttribute());
            }
            this.createPropertiesFiles();
            this.fireEvent(Level.FINE, "Done!!!", 100.0);
        } else {
            this.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
        }
    }

    private void createSampleImage() {
        if (this.defaultCM != null && this.defaultSM != null) {
            File sampleImageFile = new File(this.runConfiguration.getRootMosaicDirectory() + "/sample_image");
            try {
                Utils.storeSampleImage(sampleImageFile, this.defaultSM, this.defaultCM);
            }
            catch (IOException e) {
                this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            }
        }
    }

    private void closeIndexObjects() {
        try {
            if (this.catalog != null) {
                this.catalog.dispose();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.catalog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createPropertiesFiles() {
        block23: {
            String runtimeAttribute;
            String elevationAttribute;
            this.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
            Properties properties = new Properties();
            properties.setProperty("AbsolutePath", Boolean.toString(this.mosaicConfiguration.isAbsolutePath()));
            properties.setProperty("LocationAttribute", this.mosaicConfiguration.getLocationAttribute());
            String timeAttribute = this.mosaicConfiguration.getTimeAttribute();
            if (timeAttribute != null) {
                properties.setProperty("TimeAttribute", this.mosaicConfiguration.getTimeAttribute());
            }
            if ((elevationAttribute = this.mosaicConfiguration.getElevationAttribute()) != null) {
                properties.setProperty("ElevationAttribute", this.mosaicConfiguration.getElevationAttribute());
            }
            if ((runtimeAttribute = this.mosaicConfiguration.getRuntimeAttribute()) != null) {
                properties.setProperty("RuntimeAttribute", this.mosaicConfiguration.getRuntimeAttribute());
            }
            int numberOfLevels = this.mosaicConfiguration.getLevelsNum();
            double[][] resolutionLevels = this.mosaicConfiguration.getLevels();
            properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
            StringBuilder levels = new StringBuilder();
            for (int k = 0; k < numberOfLevels; ++k) {
                levels.append(Double.toString(resolutionLevels[0][k])).append(",").append(Double.toString(resolutionLevels[1][k]));
                if (k >= numberOfLevels - 1) continue;
                levels.append(" ");
            }
            properties.setProperty("Levels", levels.toString());
            properties.setProperty("Name", this.runConfiguration.getIndexName());
            properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
            properties.setProperty("Heterogeneous", Boolean.toString(this.mosaicConfiguration.isHeterogeneous()));
            if (this.cachedSPI != null) {
                properties.setProperty("SuggestedSPI", this.cachedSPI.getClass().getName());
            }
            if (this.imposedBBox != null) {
                properties.setProperty("Envelope2D", this.imposedBBox.getMinX() + "," + this.imposedBBox.getMinY() + " " + this.imposedBBox.getMaxX() + "," + this.imposedBBox.getMaxY());
            }
            properties.setProperty("Caching", Boolean.toString(this.mosaicConfiguration.isCaching()));
            OutputStream outStream = null;
            outStream = new BufferedOutputStream(new FileOutputStream(this.runConfiguration.getRootMosaicDirectory() + "/" + this.runConfiguration.getIndexName() + ".properties"));
            properties.store(outStream, "-Automagically created from GeoTools-");
            Object var11_10 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
                break block23;
            }
            catch (Throwable e2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                }
                break block23;
            }
            {
                catch (FileNotFoundException e) {
                    this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                    Object var11_11 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block23;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                        break block23;
                    }
                }
                catch (IOException e) {
                    this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                    Object var11_12 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block23;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object var11_13 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Throwable e2) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block24;
                        LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public void dispose() {
        this.reset();
    }

    private static boolean setupResolutions(double[][] resolutionLevels, int numberOfLevels, AbstractGridCoverage2DReader coverageReader, ImageReader imageioReader, double[][] compareLevels) throws IndexOutOfBoundsException, IOException {
        boolean checkLevels;
        double[] res = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
        resolutionLevels[0][0] = res[0];
        resolutionLevels[1][0] = res[1];
        boolean bl = checkLevels = compareLevels != null;
        if (numberOfLevels >= 1) {
            for (int k = 0; k < numberOfLevels; ++k) {
                resolutionLevels[0][k] = resolutionLevels[0][0] * (double)coverageReader.getOriginalGridRange().getSpan(0) / (1.0 * (double)imageioReader.getWidth(k));
                resolutionLevels[1][k] = resolutionLevels[1][0] * (double)coverageReader.getOriginalGridRange().getSpan(1) / (1.0 * (double)imageioReader.getHeight(k));
                if (!checkLevels || !(Math.abs(resolutionLevels[0][k] - compareLevels[0][k]) > 0.01 * compareLevels[0][k]) && !(Math.abs(resolutionLevels[1][k] - compareLevels[1][k]) > 0.01 * compareLevels[1][k])) continue;
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ int access$208(CatalogBuilder x0) {
        return x0.fileIndex++;
    }

    static /* synthetic */ void access$300(CatalogBuilder x0, Exception x1) {
        x0.fireException(x1);
    }

    static /* synthetic */ ImageReaderSpi access$600(CatalogBuilder x0) {
        return x0.cachedSPI;
    }

    static /* synthetic */ ImageReaderSpi access$602(CatalogBuilder x0, ImageReaderSpi x1) {
        x0.cachedSPI = x1;
        return x0.cachedSPI;
    }

    static /* synthetic */ ColorModel access$902(CatalogBuilder x0, ColorModel x1) {
        x0.defaultCM = x1;
        return x0.defaultCM;
    }

    static /* synthetic */ SampleModel access$1002(CatalogBuilder x0, SampleModel x1) {
        x0.defaultSM = x1;
        return x0.defaultSM;
    }

    static /* synthetic */ ColorModel access$900(CatalogBuilder x0) {
        return x0.defaultCM;
    }

    static /* synthetic */ byte[][] access$1102(CatalogBuilder x0, byte[][] x1) {
        x0.defaultPalette = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$1100(CatalogBuilder x0) {
        return x0.defaultPalette;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1202(CatalogBuilder x0, CoordinateReferenceSystem x1) {
        x0.defaultCRS = x1;
        return x0.defaultCRS;
    }

    static /* synthetic */ boolean access$1300(double[][] x0, int x1, AbstractGridCoverage2DReader x2, ImageReader x3, double[][] x4) throws IndexOutOfBoundsException, IOException {
        return CatalogBuilder.setupResolutions(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ MosaicConfigurationBean access$1400(CatalogBuilder x0) {
        return x0.mosaicConfiguration;
    }

    static /* synthetic */ GranuleCatalog access$1500(CatalogBuilder x0) {
        return x0.catalog;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1200(CatalogBuilder x0) {
        return x0.defaultCRS;
    }

    static /* synthetic */ GeometryFactory access$1600(CatalogBuilder x0) {
        return x0.geomFactory;
    }

    static /* synthetic */ List access$1700(CatalogBuilder x0) {
        return x0.propertiesCollectors;
    }

    static /* synthetic */ int access$808(CatalogBuilder x0) {
        return x0.numberOfProcessedFiles++;
    }

    final class CatalogBuilderDirectoryWalker
    extends DirectoryWalker {
        private AbstractGridFormat cachedFormat;
        private SimpleFeatureType indexSchema;
        private DefaultTransaction transaction;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            super.handleCancelled(startDirectory, results, cancel);
            try {
                this.transaction.rollback();
            }
            finally {
                this.transaction.close();
            }
            CatalogBuilder.this.closeIndexObjects();
            super.handleEnd(results);
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            return CatalogBuilder.this.stop && super.handleIsCancelled(file, depth, results);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void handleFile(File fileBeingProcessed, int depth, Collection results) throws IOException {
            block108: {
                CatalogBuilder.access$208(CatalogBuilder.this);
                if (!this.checkFile(fileBeingProcessed)) {
                    return;
                }
                if (!this.checkStop()) {
                    return;
                }
                try {
                    validFileName = fileBeingProcessed.getCanonicalPath();
                    validFileName = FilenameUtils.normalize((String)validFileName);
                }
                catch (IOException e1) {
                    CatalogBuilder.access$300(CatalogBuilder.this, e1);
                    return;
                }
                validFileName = FilenameUtils.getName((String)validFileName);
                CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, "Now indexing file " + validFileName, (double)CatalogBuilder.access$200(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                inStream = null;
                imageioReader = null;
                coverageReader = null;
                try {
                    block116: {
                        block117: {
                            block114: {
                                block115: {
                                    block113: {
                                        block112: {
                                            block111: {
                                                block110: {
                                                    block109: {
                                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                                        if (inStream != null) break block109;
                                                        CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.access$200(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                                                        var17_9 = null;
                                                        ** GOTO lbl252
                                                    }
                                                    inStream.mark();
                                                    if (CatalogBuilder.access$600(CatalogBuilder.this) != null) break block110;
                                                    it = ImageIO.getImageReaders(inStream);
                                                    if (it.hasNext()) {
                                                        imageioReader = it.next();
                                                        if (imageioReader != null) {
                                                            CatalogBuilder.access$602(CatalogBuilder.this, imageioReader.getOriginatingProvider());
                                                            imageioReader.setInput(inStream);
                                                        }
                                                        break block111;
                                                    } else {
                                                        imageioReader = null;
                                                    }
                                                    break block111;
                                                }
                                                if (!CatalogBuilder.access$600(CatalogBuilder.this).canDecodeInput(inStream)) {
                                                    CatalogBuilder.access$602(CatalogBuilder.this, null);
                                                } else {
                                                    imageioReader = CatalogBuilder.access$600(CatalogBuilder.this).createReaderInstance();
                                                    imageioReader.setInput(inStream);
                                                }
                                            }
                                            if (imageioReader != null) break block112;
                                            CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ":No ImageIO reader\ts availaible.", (double)CatalogBuilder.access$200(CatalogBuilder.this) * 99.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                                            ** GOTO lbl276
                                        }
                                        format /* !! */  = this.cachedFormat == null ? GridFormatFinder.findFormat((Object)fileBeingProcessed) : (this.cachedFormat.accepts((Object)fileBeingProcessed) != false ? this.cachedFormat : new UnknownFormat());
                                        if (!(format /* !! */  instanceof UnknownFormat) && format /* !! */  != null) break block113;
                                        CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ": File format is not supported.", (double)CatalogBuilder.access$200(CatalogBuilder.this) * 99.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                                        ** GOTO lbl301
                                    }
                                    this.cachedFormat = format /* !! */ ;
                                    coverageReader = format /* !! */ .getReader((Object)fileBeingProcessed, CatalogBuilder.access$700(CatalogBuilder.this).getHints());
                                    envelope = coverageReader.getOriginalEnvelope();
                                    actualCRS = coverageReader.getCrs();
                                    its = imageioReader.getImageTypes(0).next();
                                    if (CatalogBuilder.access$800(CatalogBuilder.this) != 0) break block114;
                                    CatalogBuilder.access$902(CatalogBuilder.this, its.getColorModel());
                                    CatalogBuilder.access$1002(CatalogBuilder.this, its.getSampleModel());
                                    if (CatalogBuilder.access$900(CatalogBuilder.this) instanceof IndexColorModel) {
                                        icm = (IndexColorModel)CatalogBuilder.access$900(CatalogBuilder.this);
                                        numBands = CatalogBuilder.access$900(CatalogBuilder.this).getNumColorComponents();
                                        CatalogBuilder.access$1102(CatalogBuilder.this, new byte[3][icm.getMapSize()]);
                                        icm.getReds(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        icm.getGreens(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        icm.getBlues(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        if (numBands == 4) {
                                            icm.getAlphas(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        }
                                    }
                                    CatalogBuilder.access$1202(CatalogBuilder.this, actualCRS);
                                    imageioReader.reset();
                                    try {
                                        inStream.reset();
                                    }
                                    catch (IOException e) {
                                        block87: {
                                            try {
                                                inStream.close();
                                            }
                                            catch (Throwable e1) {
                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINE)) break block87;
                                                CatalogBuilder.LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                                            }
                                        }
                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                    }
                                    if (inStream != null) break block115;
                                    CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.access$200(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                                    ** GOTO lbl326
                                }
                                imageioReader.setInput(inStream);
                                numberOfLevels = imageioReader.getNumImages(true);
                                resolutionLevels = new double[2][numberOfLevels];
                                CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                                CatalogBuilder.access$1400(CatalogBuilder.this).setLevelsNum(numberOfLevels);
                                CatalogBuilder.access$1400(CatalogBuilder.this).setLevels(resolutionLevels);
                                schemaDef = CatalogBuilder.access$700(CatalogBuilder.this).getSchema();
                                if (schemaDef != null) {
                                    try {
                                        this.indexSchema = DataUtilities.createType((String)CatalogBuilder.access$1400(CatalogBuilder.this).getName(), (String)CatalogBuilder.access$700(CatalogBuilder.this).getSchema());
                                        this.indexSchema = DataUtilities.createSubType((SimpleFeatureType)this.indexSchema, (String[])DataUtilities.attributeNames((SimpleFeatureType)this.indexSchema), (CoordinateReferenceSystem)actualCRS);
                                    }
                                    catch (Throwable e) {
                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINE)) {
                                            CatalogBuilder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                        }
                                        this.indexSchema = null;
                                    }
                                }
                                if (this.indexSchema == null) {
                                    featureBuilder = new SimpleFeatureTypeBuilder();
                                    featureBuilder.setName(CatalogBuilder.access$700(CatalogBuilder.this).getIndexName());
                                    featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                                    featureBuilder.add(CatalogBuilder.access$700(CatalogBuilder.this).getLocationAttribute(), String.class);
                                    featureBuilder.add("the_geom", Polygon.class, actualCRS);
                                    featureBuilder.setDefaultGeometry("the_geom");
                                    if (CatalogBuilder.access$700(CatalogBuilder.this).getTimeAttribute() != null) {
                                        featureBuilder.add(CatalogBuilder.access$700(CatalogBuilder.this).getTimeAttribute(), Date.class);
                                    }
                                    this.indexSchema = featureBuilder.buildFeatureType();
                                }
                                CatalogBuilder.access$1500(CatalogBuilder.this).createType(this.indexSchema);
                                break block116;
                            }
                            if (!CatalogBuilder.access$1400(CatalogBuilder.this).isHeterogeneous()) {
                                numberOfLevels = imageioReader.getNumImages(true);
                                if (numberOfLevels != CatalogBuilder.access$1400(CatalogBuilder.this).getLevelsNum()) {
                                    CatalogBuilder.access$1400(CatalogBuilder.this).setHeterogeneous(true);
                                    if (numberOfLevels > CatalogBuilder.access$1400(CatalogBuilder.this).getLevelsNum()) {
                                        resolutionLevels = new double[2][numberOfLevels];
                                        CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setLevelsNum(numberOfLevels);
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setLevels(resolutionLevels);
                                    }
                                } else {
                                    resolutionLevels = new double[2][numberOfLevels];
                                    mosaicLevels = CatalogBuilder.access$1400(CatalogBuilder.this).getLevels();
                                    homogeneousLevels = CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, mosaicLevels);
                                    if (!homogeneousLevels) {
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setHeterogeneous(true);
                                    }
                                }
                            }
                            actualCM = its.getColorModel();
                            if (CatalogBuilder.access$200(CatalogBuilder.this) <= 0 || CRS.equalsIgnoreMetadata((Object)CatalogBuilder.access$1200(CatalogBuilder.this), (Object)actualCRS)) break block117;
                            CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because CRSs do not match.", (double)(CatalogBuilder.access$200(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                            ** GOTO lbl351
                        }
                        if (!this.checkColorModels(CatalogBuilder.access$900(CatalogBuilder.this), CatalogBuilder.access$1100(CatalogBuilder.this), actualCM)) break block116;
                        CatalogBuilder.access$500(CatalogBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because color models do not match.", (double)(CatalogBuilder.access$200(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                        ** GOTO lbl376
                    }
                    feature = DataUtilities.template((SimpleFeatureType)this.indexSchema);
                    feature.setAttribute(this.indexSchema.getGeometryDescriptor().getLocalName(), (Object)CatalogBuilder.access$1600(CatalogBuilder.this).toGeometry(new ReferencedEnvelope((Envelope)envelope)));
                    feature.setAttribute(CatalogBuilder.access$700(CatalogBuilder.this).getLocationAttribute(), (Object)this.prepareLocation(fileBeingProcessed));
                    if (CatalogBuilder.access$1700(CatalogBuilder.this) != null && CatalogBuilder.access$1700(CatalogBuilder.this).size() > 0) {
                        for (PropertiesCollector pc : CatalogBuilder.access$1700(CatalogBuilder.this)) {
                            pc.collect(fileBeingProcessed).collect(coverageReader).collect(imageioReader).setProperties(feature);
                            pc.reset();
                        }
                    }
                    CatalogBuilder.access$1500(CatalogBuilder.this).addGranule(feature, (Transaction)this.transaction);
                    CatalogBuilder.access$500(CatalogBuilder.this, Level.FINE, "Done with file " + fileBeingProcessed, (double)(CatalogBuilder.access$200(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$400(CatalogBuilder.this));
                    CatalogBuilder.access$808(CatalogBuilder.this);
                    ** GOTO lbl401
                }
                catch (IOException e) {
                    block89: {
                        block88: {
                            CatalogBuilder.access$300(CatalogBuilder.this, e);
                            var17_16 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block88;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (imageioReader != null) {
                                imageioReader.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block89;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (coverageReader == null) return;
                        coverageReader.dispose();
                        return;
                    }
                    catch (Throwable e) {
                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    block91: {
                        block90: {
                            CatalogBuilder.access$300(CatalogBuilder.this, e);
                            var17_17 = null;
                            ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl202:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block90;
lbl205:
                            // 1 sources

                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block90;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl210:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block91;
lbl213:
                        // 1 sources

                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block91;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl218:
                    // 1 sources

                    if (coverageReader == null) return;
                    coverageReader.dispose();
                    return;
lbl221:
                    // 1 sources

                    catch (Throwable e) {
                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                {
                    block107: {
                        block106: {
                            block105: {
                                block104: {
                                    block103: {
                                        block102: {
                                            block101: {
                                                block100: {
                                                    block99: {
                                                        block98: {
                                                            block97: {
                                                                block96: {
                                                                    block95: {
                                                                        block94: {
                                                                            catch (Throwable var16_48) {
                                                                                block93: {
                                                                                    block92: {
                                                                                        var17_18 = null;
                                                                                        ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl229:
                                                                                        // 1 sources

                                                                                        if (inStream != null) {
                                                                                            inStream.close();
                                                                                        }
                                                                                        break block92;
lbl232:
                                                                                        // 1 sources

                                                                                        catch (Throwable e) {
                                                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block92;
                                                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                        }
                                                                                    }
                                                                                    ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl237:
                                                                                    // 1 sources

                                                                                    if (imageioReader != null) {
                                                                                        imageioReader.dispose();
                                                                                    }
                                                                                    break block93;
lbl240:
                                                                                    // 1 sources

                                                                                    catch (Throwable e) {
                                                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block93;
                                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                    }
                                                                                }
                                                                                ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl245:
                                                                                // 1 sources

                                                                                if (coverageReader == null) throw var16_48;
                                                                                coverageReader.dispose();
                                                                                throw var16_48;
lbl248:
                                                                                // 1 sources

                                                                                catch (Throwable e) {
                                                                                    if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) throw var16_48;
                                                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                }
                                                                                throw var16_48;
                                                                            }
lbl252:
                                                                            // 1 sources

                                                                            ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl253:
                                                                            // 1 sources

                                                                            if (inStream != null) {
                                                                                inStream.close();
                                                                            }
                                                                            break block94;
lbl256:
                                                                            // 1 sources

                                                                            catch (Throwable e) {
                                                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block94;
                                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                            }
                                                                        }
                                                                        ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl261:
                                                                        // 1 sources

                                                                        if (imageioReader != null) {
                                                                            imageioReader.dispose();
                                                                        }
                                                                        break block95;
lbl264:
                                                                        // 1 sources

                                                                        catch (Throwable e) {
                                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block95;
                                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                        }
                                                                    }
                                                                    ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl269:
                                                                    // 1 sources

                                                                    if (coverageReader == null) return;
                                                                    coverageReader.dispose();
                                                                    return;
lbl272:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                    return;
lbl276:
                                                                    // 1 sources

                                                                    var17_10 = null;
                                                                    ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl278:
                                                                    // 1 sources

                                                                    if (inStream != null) {
                                                                        inStream.close();
                                                                    }
                                                                    break block96;
lbl281:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block96;
                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                }
                                                                ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl286:
                                                                // 1 sources

                                                                if (imageioReader != null) {
                                                                    imageioReader.dispose();
                                                                }
                                                                break block97;
lbl289:
                                                                // 1 sources

                                                                catch (Throwable e) {
                                                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block97;
                                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                }
                                                            }
                                                            ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl294:
                                                            // 1 sources

                                                            if (coverageReader == null) return;
                                                            coverageReader.dispose();
                                                            return;
lbl297:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                            return;
lbl301:
                                                            // 1 sources

                                                            var17_11 = null;
                                                            ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl303:
                                                            // 1 sources

                                                            if (inStream != null) {
                                                                inStream.close();
                                                            }
                                                            break block98;
lbl306:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block98;
                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                        }
                                                        ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl311:
                                                        // 1 sources

                                                        if (imageioReader != null) {
                                                            imageioReader.dispose();
                                                        }
                                                        break block99;
lbl314:
                                                        // 1 sources

                                                        catch (Throwable e) {
                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block99;
                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                        }
                                                    }
                                                    ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl319:
                                                    // 1 sources

                                                    if (coverageReader == null) return;
                                                    coverageReader.dispose();
                                                    return;
lbl322:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                    return;
lbl326:
                                                    // 1 sources

                                                    var17_12 = null;
                                                    ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl328:
                                                    // 1 sources

                                                    if (inStream != null) {
                                                        inStream.close();
                                                    }
                                                    break block100;
lbl331:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block100;
                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                }
                                                ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl336:
                                                // 1 sources

                                                if (imageioReader != null) {
                                                    imageioReader.dispose();
                                                }
                                                break block101;
lbl339:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block101;
                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                }
                                            }
                                            ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl344:
                                            // 1 sources

                                            if (coverageReader == null) return;
                                            coverageReader.dispose();
                                            return;
lbl347:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                            return;
lbl351:
                                            // 1 sources

                                            var17_13 = null;
                                            ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl353:
                                            // 1 sources

                                            if (inStream != null) {
                                                inStream.close();
                                            }
                                            break block102;
lbl356:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block102;
                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl361:
                                        // 1 sources

                                        if (imageioReader != null) {
                                            imageioReader.dispose();
                                        }
                                        break block103;
lbl364:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block103;
                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                    }
                                    ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl369:
                                    // 1 sources

                                    if (coverageReader == null) return;
                                    coverageReader.dispose();
                                    return;
lbl372:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                    return;
lbl376:
                                    // 1 sources

                                    var17_14 = null;
                                    ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl378:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block104;
lbl381:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block104;
                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl386:
                                // 1 sources

                                if (imageioReader != null) {
                                    imageioReader.dispose();
                                }
                                break block105;
lbl389:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block105;
                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                            ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl394:
                            // 1 sources

                            if (coverageReader == null) return;
                            coverageReader.dispose();
                            return;
lbl397:
                            // 1 sources

                            catch (Throwable e) {
                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                            return;
lbl401:
                            // 1 sources

                            var17_15 = null;
                            ** try [egrp 6[TRYBLOCK] [28 : 1747->1762)] { 
lbl403:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block106;
lbl406:
                            // 1 sources

                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block106;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 7[TRYBLOCK] [29 : 1792->1805)] { 
lbl411:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block107;
lbl414:
                        // 1 sources

                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block107;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [30 : 1835->1848)] { 
lbl419:
                    // 1 sources

                    if (coverageReader != null) {
                        coverageReader.dispose();
                    }
lbl423:
                    // 1 sources

                    catch (Throwable e) {}
                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block108;
                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            super.handleFile(fileBeingProcessed, depth, results);
        }

        private String prepareLocation(File fileBeingProcessed) throws IOException {
            if (CatalogBuilder.this.runConfiguration.isAbsolute()) {
                return fileBeingProcessed.getAbsolutePath();
            }
            String path = fileBeingProcessed.getCanonicalPath();
            path = path.substring(CatalogBuilder.this.runConfiguration.getRootMosaicDirectory().length());
            return path;
        }

        private boolean checkStop() {
            if (CatalogBuilder.this.getStop()) {
                StringBuilder message = new StringBuilder("Stopping requested at file  ").append(CatalogBuilder.this.fileIndex).append(" of ").append(CatalogBuilder.this.numFiles).append(" files");
                CatalogBuilder.this.fireEvent(Level.INFO, message.toString(), (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        private boolean checkFile(File fileBeingProcessed) {
            if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                StringBuilder message = new StringBuilder("Skipped file ").append(fileBeingProcessed).append(" snce it seems invalid.");
                CatalogBuilder.this.fireEvent(Level.INFO, message.toString(), (double)CatalogBuilder.this.fileIndex * 99.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        public CatalogBuilderDirectoryWalker(File root, FileFilter filter) throws IOException {
            super(filter, Integer.MAX_VALUE);
            this.transaction = new DefaultTransaction("MosaicCreationTransaction" + System.nanoTime());
            this.walk(root, null);
        }

        public int getNumberOfProcessedFiles() {
            return CatalogBuilder.this.numberOfProcessedFiles;
        }

        private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
            if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
                boolean colorSpaceIsOk;
                ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
                ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
                ColorSpace defCS = defCCM.getColorSpace();
                ColorSpace actualCS = actualCCM.getColorSpace();
                boolean isBogusDef = defCS instanceof BogusColorSpace;
                boolean isBogusActual = actualCS instanceof BogusColorSpace;
                if (isBogusDef && isBogusActual) {
                    BogusColorSpace def = (BogusColorSpace)defCS;
                    BogusColorSpace act = (BogusColorSpace)actualCS;
                    colorSpaceIsOk = def.getNumComponents() == act.getNumComponents() && def.isCS_sRGB() == act.isCS_sRGB() && def.getType() == act.getType();
                } else {
                    colorSpaceIsOk = defCS.equals(actualCS);
                }
                return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !colorSpaceIsOk || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
            }
            if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
                IndexColorModel defICM = (IndexColorModel)defaultCM;
                IndexColorModel actualICM = (IndexColorModel)actualCM;
                if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                    return true;
                }
                if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                    CatalogBuilder.this.mustConvertToRGB = true;
                    return false;
                }
                int numBands = actualICM.getNumColorComponents();
                byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
                actualICM.getReds(actualPalette[0]);
                actualICM.getGreens(actualPalette[0]);
                actualICM.getBlues(actualPalette[0]);
                if (numBands == 4) {
                    actualICM.getAlphas(defaultPalette[0]);
                }
                block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                    for (int j = 0; j < numBands; ++j) {
                        if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                        CatalogBuilder.this.mustConvertToRGB = true;
                        continue block0;
                    }
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleEnd(Collection results) throws IOException {
            try {
                this.transaction.commit();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.transaction.close();
                throw throwable;
            }
            this.transaction.close();
            CatalogBuilder.this.indexingPostamble();
            super.handleEnd(results);
        }

        protected void handleStart(File startDirectory, Collection results) throws IOException {
            CatalogBuilder.this.indexingPreamble();
            super.handleStart(startDirectory, results);
        }
    }

    static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }

    public static final class ExceptionEvent
    extends ProcessingEvent {
        private static final long serialVersionUID = 2272452028229922551L;
        private Exception exception;

        public ExceptionEvent(Object source, String message, double percentage, Exception exception) {
            super(source, message, percentage);
            this.exception = exception;
        }

        public ExceptionEvent(Object source, Exception exception) {
            super(source, Utils.getMessageFromException(exception), -1.0);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ProcessingEvent
    extends EventObject {
        private static final long serialVersionUID = 6930580659705360225L;
        private String message = null;
        private double percentage = 0.0;

        public ProcessingEvent(Object source, String message, double percentage) {
            super(source);
            this.message = message;
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static abstract class ProcessingEventListener
    implements EventListener {
        public abstract void getNotification(ProcessingEvent var1);

        public abstract void exceptionOccurred(ExceptionEvent var1);
    }

    static class CommandLineCatalogBuilderRunner
    extends CommandLine {
        @Option(description="This index must use absolute or relative path", mandatory=false, name="absolute")
        private Boolean absolute;
        @Option(description="This index can use caching or not", mandatory=false, name="caching")
        private Boolean caching = true;
        @Option(description="Directories where to look for file to index", mandatory=true, name="indexingDirectories")
        private String indexingDirectoriesString;
        @Option(description="This index must handle footprint", mandatory=false, name="footprintManagement")
        private Boolean footprintManagement;
        @Option(description="Name to use for the index of this mosaic", mandatory=false, name="index")
        private String indexName;
        @Option(description="Root directory where to place the index file", mandatory=true, name="rootDirectory")
        private String rootMosaicDirectory;
        @Option(description="Wildcard to use for building the index of this mosaic", mandatory=false, name="wildcard")
        private String wildcardString = "*.*";
        @Option(description="Default location attribute for this index", mandatory=false, name="locationAttribute")
        private String locationAttribute = "location";

        public CommandLineCatalogBuilderRunner(String[] args) {
            super(args);
            if (this.absolute == null) {
                this.absolute = false;
            }
            if (this.caching == null) {
                this.caching = true;
            }
            if (this.footprintManagement == null) {
                this.footprintManagement = true;
            }
            if (this.indexName == null) {
                this.indexName = "index";
            }
        }

        public static void main(String[] args) {
            CommandLineCatalogBuilderRunner runner = new CommandLineCatalogBuilderRunner(args);
            CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
            configuration.setAbsolute(runner.absolute);
            configuration.setIndexName(runner.indexName);
            configuration.setFootprintManagement(runner.footprintManagement);
            configuration.setCaching(runner.caching);
            configuration.setRootMosaicDirectory(runner.rootMosaicDirectory);
            configuration.setWildcard(runner.wildcardString);
            configuration.setLocationAttribute(runner.locationAttribute);
            String directories = runner.indexingDirectoriesString;
            String[] dirs_ = directories.split(",");
            ArrayList<String> dirs = new ArrayList<String>();
            for (String dir : dirs_) {
                dirs.add(dir);
            }
            configuration.setIndexingDirectories(dirs);
            CatalogBuilder builder = new CatalogBuilder(configuration);
            builder.run();
        }
    }
}

