/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    static final double DEFAULT_ARTIFACTS_FILTER_PTILE_THRESHOLD = 0.1;
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicFormat.class.toString());
    static final Interpolation DEFAULT_INTERPOLATION = new InterpolationNearest();
    public static final ParameterDescriptor<List> TIME = DefaultParameterDescriptor.create((String)"TIME", (CharSequence)"A list of time objects", List.class, null, (boolean)false);
    public static final ParameterDescriptor<Filter> FILTER = new DefaultParameterDescriptor("Filter", Filter.class, null, null);
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor("Fading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor("MaxAllowedTiles", Integer.class, null, (Object)Integer.MAX_VALUE);
    public static final ParameterDescriptor<Integer> DEFAULT_ARTIFACTS_FILTER_THRESHOLD = new DefaultParameterDescriptor("DefaultArtifactsFilterThreshold", Integer.class, null, (Object)Integer.MIN_VALUE);
    public static final ParameterDescriptor<Double> ARTIFACTS_FILTER_PTILE_THRESHOLD = new DefaultParameterDescriptor("ArtifactsFilterPtileThreshold", Double.class, null, (Object)0.1);
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor("AllowMultithreading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Boolean> HANDLE_FOOTPRINT = new DefaultParameterDescriptor("HandleFootprint", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.TRUE);
    public static final ParameterDescriptor<Boolean> SET_ROI_PROPERTY = new DefaultParameterDescriptor("SetRoiProperty", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor("BackgroundValues", double[].class, null, null);
    public static final ParameterDescriptor<Interpolation> INTERPOLATION = new DefaultParameterDescriptor("Interpolation", Interpolation.class, null, (Object)DEFAULT_INTERPOLATION);
    public static final ParameterDescriptor<List> ELEVATION = DefaultParameterDescriptor.create((String)"ELEVATION", (CharSequence)"An elevation value", List.class, null, (boolean)false);

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING, MAX_ALLOWED_TILES, TIME, ELEVATION, FILTER}));
        this.writeParameters = null;
    }

    public ImageMosaicReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    public boolean accepts(Object source, Hints hints) {
        Utilities.ensureNonNull((String)"source", (Object)source);
        if (source instanceof ImageMosaicDescriptor) {
            return this.checkDescriptor((ImageMosaicDescriptor)source);
        }
        return this.checkForUrl(source, hints);
    }

    public boolean accepts(Object source) {
        return this.accepts(source, null);
    }

    private boolean checkDescriptor(ImageMosaicDescriptor source) {
        GranuleCatalog catalog = source.getCatalog();
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Mosaic configuration is missing");
            }
            return false;
        }
        if (configuration.getLevels() == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("resolution leves is unavailable ");
            }
            return false;
        }
        if (catalog == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Granule Catalog is unavailable ");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForUrl(Object source, Hints hints) {
        try {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                sourceURL = Utils.checkSource(source, hints);
                                                if (sourceURL == null) {
                                                    return false;
                                                }
                                                if (source instanceof File && !(file = (File)source).exists()) {
                                                    return false;
                                                }
                                                tileIndexStore = null;
                                                crs = null;
                                                shapefile = true;
                                                try {
                                                    sourceF = DataUtilities.urlToFile((URL)sourceURL);
                                                    if (FilenameUtils.getName((String)sourceF.getAbsolutePath()).equalsIgnoreCase("datastore.properties")) {
                                                        shapefile = false;
                                                        properties = new Properties();
                                                        stream = new FileInputStream(sourceF);
                                                        try {
                                                            properties.load(stream);
                                                            var11_12 = null;
                                                        }
                                                        catch (Throwable var10_15) {
                                                            var11_13 = null;
                                                            IOUtils.closeQuietly((InputStream)stream);
                                                            throw var10_15;
                                                        }
                                                        IOUtils.closeQuietly((InputStream)stream);
                                                        SPIClass = properties.getProperty("SPI");
                                                        spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                                                        params = new HashMap<String, Serializable>();
                                                        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
                                                            if (properties.containsKey(p.key)) {
                                                                params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                                                                continue;
                                                            }
                                                            if (!p.required || p.sample != null) continue;
                                                            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE)) {
                                                                ImageMosaicFormat.LOGGER.fine("Required parameter missing: " + p.toString());
                                                            }
                                                            var18_31 = false;
                                                            var20_33 = null;
                                                            try {
                                                                if (tileIndexStore == null) return var18_31;
                                                                tileIndexStore.dispose();
                                                                return var18_31;
                                                            }
                                                            catch (Throwable e) {
                                                                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var18_31;
                                                                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                            }
                                                            return var18_31;
                                                        }
                                                        tileIndexStore = spi.createDataStore(params);
                                                        if (tileIndexStore == null) {
                                                            arr$ = false;
                                                            var20_34 = null;
                                                            ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl55:
                                                            // 1 sources

                                                            if (tileIndexStore == null) return arr$;
                                                            tileIndexStore.dispose();
                                                            return arr$;
lbl58:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return arr$;
                                                                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                            }
                                                            return arr$;
                                                        }
                                                    } else {
                                                        testPropertiesUrl = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
                                                        testFile = DataUtilities.urlToFile((URL)testPropertiesUrl);
                                                        if (!testFile.exists()) {
                                                            SPIClass = false;
                                                            break block38;
                                                        }
                                                        tileIndexStore = new ShapefileDataStore(sourceURL);
                                                    }
                                                    if ((typeNames = tileIndexStore.getTypeNames()).length <= 0) {
                                                        testFile = false;
                                                        break block39;
                                                    }
                                                    typeName = typeNames[0];
                                                    if (typeName == null) {
                                                        SPIClass = false;
                                                        break block40;
                                                    }
                                                    featureSource = tileIndexStore.getFeatureSource(typeName);
                                                    if (featureSource == null) {
                                                        spi = false;
                                                        break block41;
                                                    }
                                                    schema = (SimpleFeatureType)featureSource.getSchema();
                                                    if (schema == null) {
                                                        params = false;
                                                        break block42;
                                                    }
                                                    crs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                                                    if (crs == null) {
                                                        params = false;
                                                        break block43;
                                                    }
                                                    propsUrl = null;
                                                    if (shapefile) {
                                                        propsUrl = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
                                                    } else {
                                                        parent = DataUtilities.urlToFile((URL)sourceURL).getParentFile();
                                                        for (File propFile : properties = parent.listFiles((FilenameFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), (IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), (IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")))))) {
                                                            if (!Utils.checkFileReadable(propFile) || Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), "") == null) continue;
                                                            propsUrl = DataUtilities.fileToURL((File)propFile);
                                                            break;
                                                        }
                                                    }
                                                    props = Utils.loadMosaicProperties(propsUrl, "location");
                                                    if (props == null) {
                                                        properties = false;
                                                        break block44;
                                                    }
                                                    locationAttributeName = props.getLocationAttribute();
                                                    if (schema.getDescriptor(locationAttributeName) == null) {
                                                        var15_26 = false;
                                                        break block45;
                                                    }
                                                    var15_26 = true;
                                                    break block46;
                                                }
                                                catch (Throwable var19_57) {
                                                    var20_44 = null;
                                                    ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl120:
                                                    // 1 sources

                                                    if (tileIndexStore == null) throw var19_57;
                                                    tileIndexStore.dispose();
                                                    throw var19_57;
lbl123:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) throw var19_57;
                                                        ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                    }
                                                    throw var19_57;
                                                }
                                            }
                                            var20_35 = null;
                                            ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl130:
                                            // 1 sources

                                            if (tileIndexStore == null) return SPIClass;
                                            tileIndexStore.dispose();
                                            return SPIClass;
lbl133:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return SPIClass;
                                                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                            }
                                            return SPIClass;
                                        }
                                        var20_36 = null;
                                        ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl140:
                                        // 1 sources

                                        if (tileIndexStore == null) return testFile;
                                        tileIndexStore.dispose();
                                        return testFile;
lbl143:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return testFile;
                                            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                        }
                                        return testFile;
                                    }
                                    var20_37 = null;
                                    ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl150:
                                    // 1 sources

                                    if (tileIndexStore == null) return SPIClass;
                                    tileIndexStore.dispose();
                                    return SPIClass;
lbl153:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return SPIClass;
                                        ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                    return SPIClass;
                                }
                                var20_38 = null;
                                ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl160:
                                // 1 sources

                                if (tileIndexStore == null) return spi;
                                tileIndexStore.dispose();
                                return spi;
lbl163:
                                // 1 sources

                                catch (Throwable e) {
                                    if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return spi;
                                    ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return spi;
                            }
                            var20_39 = null;
                            ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl170:
                            // 1 sources

                            if (tileIndexStore == null) return params;
                            tileIndexStore.dispose();
                            return params;
lbl173:
                            // 1 sources

                            catch (Throwable e) {
                                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return params;
                                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                            return params;
                        }
                        var20_40 = null;
                        ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl180:
                        // 1 sources

                        if (tileIndexStore == null) return params;
                        tileIndexStore.dispose();
                        return params;
lbl183:
                        // 1 sources

                        catch (Throwable e) {
                            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return params;
                            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        return params;
                    }
                    var20_41 = null;
                    ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl190:
                    // 1 sources

                    if (tileIndexStore == null) return properties;
                    tileIndexStore.dispose();
                    return properties;
lbl193:
                    // 1 sources

                    catch (Throwable e) {
                        if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return properties;
                        ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    return properties;
                }
                var20_42 = null;
                ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl200:
                // 1 sources

                if (tileIndexStore == null) return var15_26;
                tileIndexStore.dispose();
                return var15_26;
lbl203:
                // 1 sources

                catch (Throwable e) {
                    if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var15_26;
                    ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return var15_26;
            }
            var20_43 = null;
            ** try [egrp 3[TRYBLOCK] [14 : 706->721)] { 
lbl210:
            // 1 sources

            if (tileIndexStore == null) return var15_26;
            tileIndexStore.dispose();
            return var15_26;
lbl213:
            // 1 sources

            catch (Throwable e) {
                if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return var15_26;
                ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return var15_26;
        }
        catch (Throwable e) {
            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return false;
            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImageMosaicReader getReader(Object source, Hints hints) {
        try {
            ImageMosaicReader reader = new ImageMosaicReader(source, hints);
            return reader;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }
}

