/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.util.Arrays;
import org.geotools.referencing.piecewise.DefaultLinearPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapTransformElement;
import org.geotools.renderer.lite.gridcoverage2d.ConstantColorMapElement;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.opengis.referencing.operation.MathTransform1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearColorMapElement
extends DefaultLinearPiecewiseTransform1DElement
implements PiecewiseTransform1DElement,
ColorMapTransformElement {
    private static final long serialVersionUID = 2216106857184603629L;
    private Color[] colors;
    private int hashCode = -1;

    public static LinearColorMapElement create(CharSequence name, Color[] colors, NumberRange<? extends Number> valueRange, NumberRange<? extends Number> sampleRange) throws IllegalArgumentException {
        return new LinearColorMapElement(name, colors, valueRange, sampleRange);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, NumberRange<? extends Number> inRange, int outVal) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, inRange, outVal);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, short value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, int value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, float value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, double value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    LinearColorMapElement(CharSequence name, Color[] colors, NumberRange<? extends Number> valueRange, NumberRange<? extends Number> sampleRange) throws IllegalArgumentException {
        super(name, valueRange, LinearColorMapElement.checkSampleRange(sampleRange));
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
    }

    private static NumberRange<? extends Number> checkSampleRange(NumberRange<? extends Number> numberRange) {
        if (numberRange == null) {
            throw new IllegalArgumentException();
        }
        Class elementClass = numberRange.getElementClass();
        if (!(elementClass.equals(Integer.class) || elementClass.equals(Byte.class) || elementClass.equals(Short.class))) {
            throw new IllegalArgumentException(Errors.format(9, numberRange));
        }
        if (numberRange.getMinimum() < 0.0 || numberRange.getMaximum() > 65535.0) {
            throw new IndexOutOfBoundsException(Errors.format(9, numberRange));
        }
        return numberRange;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LinearColorMapElement)) {
            return false;
        }
        LinearColorMapElement that = (LinearColorMapElement)object;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (Arrays.equals(this.getColors(), that.getColors())) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public Color[] getColors() {
        return (Color[])this.colors.clone();
    }

    MathTransform1D accessTransform() {
        return this.getTransform();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n").append("colors=");
        for (int i = 0; this.colors != null && i < this.colors.length; ++i) {
            buffer.append(this.colors[i]);
            if (i + 1 >= this.colors.length) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return LinearColorMapElement.class;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = Utilities.hash((Object)this.colors, (int)this.hashCode);
        this.hashCode = Utilities.hash((int)super.hashCode(), (int)this.hashCode);
        return this.hashCode;
    }
}

