/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.memory.CollectionSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.GeometryTransformationVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.ScreenMap;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.OpacityFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.SimpleGeometryFactory;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.SymbolizerAssociation;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.PolygonSymbolizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamingRenderer
implements GTRenderer {
    private static final int defaultMaxFiltersToSendToDatastore = 5;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    int error = 0;
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private static final PropertyName gridPropertyName = filterFactory.property("grid");
    private static final PropertyName paramsPropertyName = filterFactory.property("params");
    private static final PropertyName defaultGeometryPropertyName = filterFactory.property("");
    private MapContext context;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private ReferencedEnvelope mapExtent;
    private ReferencedEnvelope originalMapExtent;
    private ProjectionHandler projectionHandler;
    private Rectangle screenSize;
    private boolean renderingStopRequested = false;
    private double scaleDenominator;
    private double generalizationDistance = 0.8;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    protected LabelCache labelCache = new LabelCacheImpl();
    private StyledShapePainter painter = new StyledShapePainter();
    private BlockingQueue<RenderingRequest> requests;
    private IndexedFeatureResults indexedFeatureResults;
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    private RenderingHints java2dHints;
    private boolean optimizedDataLoadingEnabledDEFAULT = true;
    private int renderingBufferDEFAULT = 0;
    private String scaleComputationMethodDEFAULT = "OGC";
    public static final String TEXT_RENDERING_STRING = LabelCacheImpl.LabelRenderingMode.STRING.name();
    public static final String TEXT_RENDERING_OUTLINE = LabelCacheImpl.LabelRenderingMode.OUTLINE.name();
    public static final String TEXT_RENDERING_ADAPTIVE = LabelCacheImpl.LabelRenderingMode.ADAPTIVE.name();
    public static final String TEXT_RENDERING_KEY = "textRenderingMethod";
    private String textRenderingModeDEFAULT = TEXT_RENDERING_STRING;
    public static final String LINE_WIDTH_OPTIMIZATION_KEY = "lineWidthOptimization";
    public static final String OPTIMIZE_FTS_RENDERING_KEY = "optimizeFTSRendering";
    public static final String ADVANCED_PROJECTION_HANDLING_KEY = "advancedProjectionHandling";
    public static final String CONTINUOUS_MAP_WRAPPING = "continuousMapWrapping";
    public static final String VECTOR_RENDERING_KEY = "vectorRenderingEnabled";
    private static boolean VECTOR_RENDERING_ENABLED_DEFAULT = false;
    public static final String LABEL_CACHE_KEY = "labelCache";
    public static final String DPI_KEY = "dpi";
    public static final String DECLARED_SCALE_DENOM_KEY = "declaredScaleDenominator";
    public static final String OPTIMIZED_DATA_LOADING_KEY = "optimizedDataLoadingEnabled";
    public static final String SCALE_COMPUTATION_METHOD_KEY = "scaleComputationMethod";
    private Map rendererHints = null;
    private AffineTransform worldToScreenTransform = null;
    private CoordinateReferenceSystem destinationCrs;
    private boolean canTransform;
    private boolean inMemoryGeneralization = true;
    private ExecutorService threadPool;
    private static final Decimator NULL_DECIMATOR = new Decimator(-1.0, -1.0);

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    @Override
    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    @Override
    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Object feature) {
        if (!(feature instanceof SimpleFeature)) {
            if (feature instanceof Feature) {
                LOGGER.log(Level.FINE, "Skipping non simple feature rendering notification");
            }
            return;
        }
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.featureRenderer((SimpleFeature)feature);
            }
        }
    }

    private void fireErrorEvent(Throwable t) {
        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
        if (this.renderListeners.size() > 0) {
            Exception e = t instanceof Exception ? (Exception)t : new Exception(t);
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.errorOccurred(e);
            }
        }
    }

    @Override
    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            Envelope mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(e);
        }
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea, AffineTransform worldToScreen) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.context.getCoordinateReferenceSystem()), worldToScreen);
    }

    private double computeScale(ReferencedEnvelope envelope, Rectangle paintArea, AffineTransform worldToScreen, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale(envelope, paintArea.width, paintArea.height, hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine(envelope.getCoordinateReferenceSystem(), worldToScreen, hints);
        }
        return RendererUtilities.calculateOGCScale(envelope, paintArea.width, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea, AffineTransform worldToScreen) {
        if (graphics == null || paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null && paintArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (mapArea == null) {
            LOGGER.severe("renderer passed null arguments");
            throw new NullPointerException("renderer passed null arguments");
        }
        if (worldToScreen == null && (worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea)) == null) {
            return;
        }
        this.destinationCrs = mapArea.getCoordinateReferenceSystem();
        this.mapExtent = new ReferencedEnvelope(mapArea);
        this.screenSize = paintArea;
        this.worldToScreenTransform = worldToScreen;
        this.error = 0;
        if (this.java2dHints != null) {
            graphics.setRenderingHints(this.java2dHints);
        }
        this.renderingStopRequested = false;
        graphics.setClip(paintArea);
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(this.worldToScreenTransform);
            this.worldToScreenTransform = atg;
            graphics.setTransform(this.worldToScreenTransform);
        }
        this.scaleDenominator = this.computeScale(mapArea, paintArea, this.worldToScreenTransform, this.rendererHints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Computed scale denominator: " + this.scaleDenominator);
        }
        int buffer = this.getRenderingBuffer();
        this.originalMapExtent = this.mapExtent;
        if (buffer > 0) {
            this.mapExtent = new ReferencedEnvelope(this.expandEnvelope(this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
        }
        if (this.isAdvancedProjectionHandlingEnabled()) {
            this.projectionHandler = ProjectionHandlerFinder.getHandler(this.mapExtent, this.isMapWrappingEnabled());
        }
        this.requests = new ArrayBlockingQueue<RenderingRequest>(10000);
        PainterThread painterThread = new PainterThread(this.requests);
        ExecutorService localThreadPool = this.threadPool;
        boolean localPool = false;
        if (localThreadPool == null) {
            localThreadPool = Executors.newSingleThreadExecutor();
            localPool = true;
        }
        Future<?> painterFuture = localThreadPool.submit(painterThread);
        try {
            MapLayer[] layers = this.context.getLayers();
            this.labelCache.start();
            if (this.labelCache instanceof LabelCacheImpl) {
                ((LabelCacheImpl)this.labelCache).setLabelRenderingMode(LabelCacheImpl.LabelRenderingMode.valueOf(this.getTextRenderingMethod()));
            }
            int layersNumber = layers.length;
            for (int i = 0; i < layersNumber; ++i) {
                MapLayer currLayer = layers[i];
                if (!currLayer.isVisible()) continue;
                if (this.renderingStopRequested) {
                    return;
                }
                this.labelCache.startLayer(i + "");
                try {
                    this.processStylers(graphics, currLayer, this.worldToScreenTransform, this.destinationCrs, this.mapExtent, this.screenSize, i + "");
                }
                catch (Throwable t) {
                    this.fireErrorEvent(t);
                }
                this.labelCache.endLayer(i + "", graphics, this.screenSize);
            }
        }
        finally {
            try {
                this.requests.put(new EndRequest());
                painterFuture.get();
            }
            catch (Exception e) {
                painterFuture.cancel(true);
                this.fireErrorEvent(e);
            }
            finally {
                if (localPool) {
                    localThreadPool.shutdown();
                }
            }
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Style cache hit ratio: ").append(this.styleFactory.getHitRatio()).append(" , hits ").append(this.styleFactory.getHits()).append(", requests ").append(this.styleFactory.getRequests()).toString());
        }
        if (this.error > 0) {
            LOGGER.warning(new StringBuffer("Number of Errors during paint(Graphics2D, AffineTransform) = ").append(this.error).toString());
        }
    }

    private Envelope expandEnvelope(Envelope envelope, AffineTransform worldToScreen, int buffer) {
        assert (buffer > 0);
        double bufferX = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleX0((AffineTransform)worldToScreen));
        double bufferY = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleY0((AffineTransform)worldToScreen));
        return new Envelope(envelope.getMinX() - bufferX, envelope.getMaxX() + bufferX, envelope.getMinY() - bufferY, envelope.getMaxY() + bufferY);
    }

    Collection queryLayer(MapLayer currLayer, CollectionSource source) {
        Collection results = null;
        Query query = new Query(Query.ALL);
        Query definitionQuery = currLayer.getQuery();
        if (definitionQuery != Query.ALL) {
            query = query == Query.ALL ? new Query(definitionQuery) : new Query(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        results = source.content(query.getFilter());
        return results;
    }

    FeatureCollection<FeatureType, Feature> queryLayer(MapLayer currLayer, FeatureSource<FeatureType, Feature> source, FeatureType schema, LiteFeatureTypeStyle[] styles, Envelope mapArea, CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, GeometryDescriptor geometryAttribute, AffineTransform worldToScreenTransform) throws IllegalFilterException, IOException {
        Query definitionQuery;
        int buffer;
        Object results = null;
        Query query = new Query(Query.ALL);
        Filter filter = null;
        if (this.getRenderingBuffer() == 0 && (buffer = this.findRenderingBuffer(styles)) > 0) {
            mapArea = this.expandEnvelope(mapArea, worldToScreenTransform, buffer);
            LOGGER.fine("Expanding rendering area by " + buffer + " pixels to consider stroke width");
        }
        String[] attributes = styles == null ? null : this.findStyleAttributes(styles, schema);
        ReferencedEnvelope envelope = new ReferencedEnvelope(mapArea, mapCRS);
        if (this.isOptimizedDataLoadingEnabled()) {
            try {
                List<ReferencedEnvelope> envelopes;
                if (this.projectionHandler != null) {
                    this.projectionHandler.setRenderingEnvelope(envelope);
                    envelopes = this.projectionHandler.getQueryEnvelopes(featCrs);
                } else {
                    envelopes = mapCRS != null && featCrs != null && !CRS.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS) ? Collections.singletonList(envelope.transform(featCrs, true, 10)) : Collections.singletonList(envelope);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Querying layer " + schema.getName() + " with bbox: " + envelope);
                }
                filter = this.createBBoxFilters(schema, attributes, envelopes);
                query = new Query(schema.getName().getLocalPart());
                query.setFilter(filter);
                query.setPropertyNames(attributes);
                this.processRuleForQuery(styles, query);
            }
            catch (Exception e) {
                this.fireErrorEvent(new Exception("Error transforming bbox", e));
                this.canTransform = false;
                query = new Query(schema.getName().getLocalPart());
                query.setPropertyNames(attributes);
                ReferencedEnvelope bounds = source.getBounds();
                if (bounds != null && envelope.intersects(bounds)) {
                    LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)", e);
                    filter = null;
                    filter = this.createBBoxFilters(schema, attributes, Collections.singletonList(envelope));
                    query.setFilter(filter);
                } else {
                    LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)", e);
                    query.setFilter((Filter)Filter.INCLUDE);
                }
                this.processRuleForQuery(styles, query);
            }
        }
        if ((definitionQuery = currLayer.getQuery()) != Query.ALL) {
            query = query == Query.ALL ? new Query(definitionQuery) : new Query(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        query.setCoordinateSystem(featCrs);
        LiteCoordinateSequenceFactory csFactory = new LiteCoordinateSequenceFactory();
        SimpleGeometryFactory gFactory = new SimpleGeometryFactory(csFactory);
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)csFactory);
        hints.put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)gFactory);
        hints.put((Object)Hints.FEATURE_2D, (Object)Boolean.TRUE);
        try {
            CoordinateReferenceSystem crs = this.getNativeCRS(schema, Arrays.asList(attributes));
            if (crs != null) {
                Set<RenderingHints.Key> fsHints = source.getSupportedHints();
                MathTransform2D mt = this.buildFullTransform(crs, mapCRS, worldToScreenTransform);
                double[] spans = Decimator.computeGeneralizationDistances(mt.inverse(), screenSize, this.generalizationDistance);
                double distance = spans[0] < spans[1] ? spans[0] : spans[1];
                for (LiteFeatureTypeStyle fts : styles) {
                    if (fts.screenMap == null) continue;
                    fts.screenMap.setTransform((MathTransform)mt);
                    fts.screenMap.setSpans(spans[0], spans[1]);
                    if (!fsHints.contains(Hints.SCREENMAP)) continue;
                    hints.put((Object)Hints.SCREENMAP, (Object)fts.screenMap);
                    fts.screenMap = null;
                }
                if (fsHints.contains(Hints.GEOMETRY_SIMPLIFICATION)) {
                    hints.put((Object)Hints.GEOMETRY_SIMPLIFICATION, (Object)distance);
                    this.inMemoryGeneralization = false;
                } else if (fsHints.contains(Hints.GEOMETRY_DISTANCE)) {
                    hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)distance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error computing the generalization hints", e);
        }
        if (query.getHints() == null) {
            query.setHints(hints);
        } else {
            query.getHints().putAll((Map)hints);
        }
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        Filter simplifiedFilter = (Filter)query.getFilter().accept((FilterVisitor)simplifier, null);
        query.setFilter(simplifiedFilter);
        return source.getFeatures(query);
    }

    ReferencedEnvelope expandEnvelopeByTransformations(LiteFeatureTypeStyle[] styles, ReferencedEnvelope envelope) {
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = new ReferencedEnvelope(envelope);
        for (LiteFeatureTypeStyle lts : styles) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            rules.addAll(Arrays.asList(lts.ruleList));
            rules.addAll(Arrays.asList(lts.elseRules));
            for (Rule r : rules) {
                for (Symbolizer s : r.symbolizers()) {
                    if (s.getGeometry() == null) continue;
                    result.expandToInclude((ReferencedEnvelope)s.getGeometry().accept((ExpressionVisitor)visitor, (Object)envelope));
                }
            }
        }
        return result;
    }

    private MathTransform2D buildFullTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS, AffineTransform worldToScreenTransform) throws FactoryException {
        MathTransform2D mt = this.buildTransform(sourceCRS, destCRS);
        mt = mt != null && !mt.isIdentity() ? (MathTransform2D)ConcatenatedTransform.create((MathTransform)mt, (MathTransform)ProjectiveTransform.create((AffineTransform)worldToScreenTransform)) : (MathTransform2D)ProjectiveTransform.create((AffineTransform)worldToScreenTransform);
        return mt;
    }

    private MathTransform2D buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        MathTransform2D mt = sourceCRS == null || destCRS == null || CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS) ? null : (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return mt;
    }

    private CoordinateReferenceSystem getNativeCRS(FeatureType schema, List<String> attNames) {
        CoordinateReferenceSystem crs = null;
        for (PropertyDescriptor att : schema.getDescriptors()) {
            if (!attNames.contains(att.getName().getLocalPart()) || !(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            CoordinateReferenceSystem gdCrs = gd.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = gdCrs;
                continue;
            }
            if (gdCrs == null) {
                crs = null;
                break;
            }
            if (CRS.equalsIgnoreMetadata((Object)crs, (Object)gdCrs)) continue;
            crs = null;
            break;
        }
        return crs;
    }

    private void processRuleForQuery(LiteFeatureTypeStyle[] styles, Query q) {
        block7: {
            try {
                int maxFilters = this.getMaxFiltersToSendToDatastore();
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                for (LiteFeatureTypeStyle style : styles) {
                    if (style.elseRules.length > 0) {
                        return;
                    }
                    for (Rule r : style.ruleList) {
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (filtersToDS.size() > maxFilters) {
                    return;
                }
                Object ruleFiltersCombined = filtersToDS.size() == 1 ? (Filter)filtersToDS.get(0) : filterFactory.or(filtersToDS);
                ruleFiltersCombined = filterFactory.and(q.getFilter(), (Filter)ruleFiltersCombined);
                q.setFilter((Filter)ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private int getMaxFiltersToSendToDatastore() {
        try {
            if (this.rendererHints == null) {
                return 5;
            }
            Integer result = (Integer)this.rendererHints.get("maxFiltersToSendToDatastore");
            if (result == null) {
                return 5;
            }
            return result;
        }
        catch (Exception e) {
            return 5;
        }
    }

    private boolean isOptimizedFTSRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(OPTIMIZE_FTS_RENDERING_KEY);
        if (result == null) {
            return true;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isAdvancedProjectionHandlingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_HANDLING_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isMapWrappingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(CONTINUOUS_MAP_WRAPPING);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isVectorRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(VECTOR_RENDERING_KEY);
        if (result == null) {
            return VECTOR_RENDERING_ENABLED_DEFAULT;
        }
        return (Boolean)result;
    }

    private int findRenderingBuffer(LiteFeatureTypeStyle[] styles) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        for (int t = 0; t < styles.length; ++t) {
            int j;
            LiteFeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.elseRules;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
            rules = lfts.ruleList;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
        }
        if (!rbe.isEstimateAccurate()) {
            LOGGER.warning("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually");
        }
        return (int)Math.round((double)rbe.getBuffer() / 2.0 + 1.0);
    }

    private String[] findStyleAttributes(LiteFeatureTypeStyle[] styles, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        for (LiteFeatureTypeStyle lfts : styles) {
            int j;
            Rule[] rules = lfts.elseRules;
            int rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
            rules = lfts.ruleList;
            rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
        }
        String[] ftsAttributes = sae.getAttributeNames();
        LinkedList<String> atts = new LinkedList<String>(Arrays.asList(ftsAttributes));
        Collection attTypes = schema.getDescriptors();
        int attTypesLength = attTypes.size();
        for (PropertyDescriptor pd : attTypes) {
            String attName = pd.getName().getLocalPart();
            if ((!attName.equalsIgnoreCase("grid") || atts.contains(attName)) && (!attName.equalsIgnoreCase("params") || atts.contains(attName))) continue;
            atts.add(attName);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("added attribute " + attName);
        }
        try {
            if (sae.getDefaultGeometryUsed() && !atts.contains(schema.getGeometryDescriptor().getLocalName())) {
                atts.add(schema.getGeometryDescriptor().getLocalName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ftsAttributes = new String[atts.size()];
        atts.toArray(ftsAttributes);
        return ftsAttributes;
    }

    private Filter createBBoxFilters(FeatureType schema, String[] attributes, List<ReferencedEnvelope> bboxes) throws IllegalFilterException {
        Object filter = Filter.INCLUDE;
        int length = attributes.length;
        for (int j = 0; j < length; ++j) {
            PropertyDescriptor attType = schema.getDescriptor(attributes[j]);
            if (attType == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("Could not find '").append(attributes[j]).append("' in the FeatureType (").append(schema.getName()).append(")").toString());
                }
                throw new IllegalFilterException(new StringBuffer("Could not find '").append(attributes[j] + "' in the FeatureType (").append(schema.getName()).append(")").toString());
            }
            if (!(attType instanceof GeometryDescriptor)) continue;
            String localName = ((GeometryDescriptor)attType).getLocalName();
            FastBBOX gfilter = new FastBBOX(localName, bboxes.get(0), filterFactory);
            filter = filter == Filter.INCLUDE ? gfilter : filterFactory.or((Filter)filter, (Filter)gfilter);
            if (bboxes.size() <= 0) continue;
            for (int k = 1; k < bboxes.size(); ++k) {
                filter = filterFactory.or((Filter)filter, (Filter)new FastBBOX(localName, bboxes.get(k), filterFactory));
            }
        }
        return filter;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(FeatureTypeStyle[] featureStyles, Object typeDescription, Graphics2D graphics) throws IOException {
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureStyles) {
            if (typeDescription == null || typeDescription.toString().indexOf(fts.getFeatureTypeName()) == -1) continue;
            List<Rule> rules = fts.rules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (Rule r : rules) {
                if (!this.isWithInScale(r)) continue;
                if (r.isElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
            LiteFeatureTypeStyle lfts = result.size() == 0 || !this.isOptimizedFTSRenderingEnabled() ? new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList) : new LiteFeatureTypeStyle(new DelayedBackbufferGraphic(graphics, this.screenSize), ruleList, elseRuleList);
            result.add(lfts);
        }
        return result;
    }

    private ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(FeatureTypeStyle[] featureStyles, FeatureType ftype, Graphics2D graphics) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("creating rules for scale denominator - " + NumberFormat.getNumberInstance().format(this.scaleDenominator));
        }
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureStyles) {
            if (!this.isFeatureTypeStyleActive(ftype, fts)) continue;
            List[] splittedRules = this.splitRules(fts);
            List ruleList = splittedRules[0];
            List elseRuleList = splittedRules[1];
            if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
            LiteFeatureTypeStyle lfts = result.size() == 0 || !this.isOptimizedFTSRenderingEnabled() ? new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList) : new LiteFeatureTypeStyle(new DelayedBackbufferGraphic(graphics, this.screenSize), ruleList, elseRuleList);
            if (this.screenMapEnabled(lfts)) {
                lfts.screenMap = new ScreenMap(this.screenSize.x, this.screenSize.y, this.screenSize.width, this.screenSize.height);
            }
            result.add(lfts);
        }
        return result;
    }

    boolean screenMapEnabled(LiteFeatureTypeStyle lfts) {
        if (this.generalizationDistance == 0.0) {
            return false;
        }
        OpacityFinder finder = new OpacityFinder(new Class[]{PointSymbolizer.class, LineSymbolizer.class, PolygonSymbolizer.class});
        for (Rule r : lfts.ruleList) {
            r.accept(finder);
        }
        for (Rule r : lfts.elseRules) {
            r.accept(finder);
        }
        return !finder.hasOpacity;
    }

    private boolean isFeatureTypeStyleActive(FeatureType ftype, FeatureTypeStyle fts) {
        return fts.featureTypeNames().isEmpty() || ftype.getName().getLocalPart() != null && (ftype.getName().getLocalPart().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom(ftype, null, fts.getFeatureTypeName()));
    }

    private List[] splitRules(FeatureTypeStyle fts) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        Rule[] rules = fts.getRules();
        ruleList = new ArrayList();
        elseRuleList = new ArrayList();
        for (int j = 0; j < rules.length; ++j) {
            Rule r = rules[j];
            if (!this.isWithInScale(r)) continue;
            if (r.isElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            ruleList.add(r);
        }
        return new List[]{ruleList, elseRuleList};
    }

    public int getMaxBackBufferMemory(int width, int height) {
        int maxBuffers = 0;
        for (MapLayer layer : this.context.getLayers()) {
            if (!layer.isVisible() || layer.getStyle().getFeatureTypeStyles().length < 2) continue;
            int currCount = 0;
            Object ftype = layer.getFeatureSource().getSchema();
            for (FeatureTypeStyle fts : layer.getStyle().getFeatureTypeStyles()) {
                if (!this.isFeatureTypeStyleActive((FeatureType)ftype, fts)) continue;
                List[] splittedRules = this.splitRules(fts);
                List ruleList = splittedRules[0];
                List elseRuleList = splittedRules[1];
                if (ruleList.size() == 0 && elseRuleList.size() == 0) continue;
                ++currCount;
            }
            if (--currCount <= maxBuffers) continue;
            maxBuffers = currCount;
        }
        return maxBuffers * width * height * 4;
    }

    private FeatureCollection prepFeatureCollection(FeatureCollection features, CoordinateReferenceSystem sourceCrs) {
        CoordinateReferenceSystem rCS = null;
        try {
            rCS = features.getSchema().getGeometryDescriptor().getType().getCoordinateReferenceSystem();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && CRS.equalsIgnoreMetadata((Object)rCS, (Object)sourceCrs))) {
            try {
                if (features instanceof SimpleFeatureCollection) {
                    return new ForceCoordinateSystemFeatureResults((SimpleFeatureCollection)features, sourceCrs);
                }
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, ee.getLocalizedMessage(), ee);
            }
        }
        return features;
    }

    private final void processStylers(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, Envelope mapArea, Rectangle screenSize, String layerId) throws IllegalFilterException, IOException {
        ArrayList<LiteFeatureTypeStyle> lfts;
        FeatureTypeStyle[] featureStylers = currLayer.getStyle().getFeatureTypeStyles();
        FeatureSource featureSource = currLayer.getFeatureSource();
        Collection collection = null;
        FeatureCollection features = null;
        NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
        if (featureSource != null) {
            Object schema = featureSource.getSchema();
            GeometryDescriptor geometryAttribute = schema.getGeometryDescriptor();
            CoordinateReferenceSystem sourceCrs = geometryAttribute.getType().getCoordinateReferenceSystem();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("processing ").append(featureStylers.length).append(" stylers for ").append(currLayer.getFeatureSource().getSchema().getName()).toString());
            }
            if ((lfts = this.createLiteFeatureTypeStyles(featureStylers, (FeatureType)schema, graphics)).size() == 0) {
                return;
            }
            this.applyUnitRescale(lfts);
            LiteFeatureTypeStyle[] featureTypeStyleArray = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]);
            this.inMemoryGeneralization = true;
            features = this.queryLayer(currLayer, featureSource, (FeatureType)schema, featureTypeStyleArray, mapArea, destinationCrs, sourceCrs, screenSize, geometryAttribute, at);
            features = this.prepFeatureCollection(features, sourceCrs);
        } else {
            CollectionSource source = currLayer.getSource();
            collection = this.queryLayer(currLayer, currLayer.getSource());
            Object sourceCrs = null;
            lfts = this.createLiteFeatureTypeStyles(featureStylers, source.describe(), graphics);
            this.applyUnitRescale(lfts);
        }
        if (lfts.size() == 0) {
            return;
        }
        if (this.isOptimizedFTSRenderingEnabled() && lfts.size() > 1) {
            this.drawOptimized(graphics, currLayer, at, destinationCrs, layerId, collection, features, scaleRange, lfts);
        } else {
            this.drawPlain(graphics, currLayer, at, destinationCrs, layerId, collection, features, scaleRange, lfts);
        }
    }

    void applyUnitRescale(ArrayList<LiteFeatureTypeStyle> lfts) {
        double standardDpi;
        double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio(this.scaleDenominator, this.rendererHints);
        UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
        for (LiteFeatureTypeStyle fts : lfts) {
            this.rescaleFeatureTypeStyle(fts, rescaleVisitor);
        }
        double dpi = RendererUtilities.getDpi(this.getRendererHints());
        if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
            double scaleFactor = dpi / standardDpi;
            RescaleStyleVisitor dpiVisitor = new RescaleStyleVisitor(scaleFactor);
            for (LiteFeatureTypeStyle fts : lfts) {
                this.rescaleFeatureTypeStyle(fts, dpiVisitor);
            }
        }
    }

    void rescaleFeatureTypeStyle(LiteFeatureTypeStyle fts, DuplicatingStyleVisitor visitor) {
        int i;
        for (i = 0; i < fts.ruleList.length; ++i) {
            visitor.visit(fts.ruleList[i]);
            fts.ruleList[i] = (Rule)visitor.getCopy();
        }
        if (fts.elseRules != null) {
            for (i = 0; i < fts.elseRules.length; ++i) {
                visitor.visit(fts.elseRules[i]);
                fts.elseRules[i] = (Rule)visitor.getCopy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPlain(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection collection, FeatureCollection features, NumberRange scaleRange, ArrayList lfts) {
        LiteFeatureTypeStyle[] fts_array;
        for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()])) {
            Iterator<Object> iterator = null;
            if (collection != null) {
                iterator = collection.iterator();
            }
            if (features != null) {
                iterator = features.iterator();
            }
            if (iterator == null) {
                return;
            }
            try {
                boolean clone = this.isCloningRequired(currLayer, fts_array);
                RenderableFeature rf = new RenderableFeature(currLayer, clone);
                while (iterator.hasNext() && !this.renderingStopRequested) {
                    try {
                        rf.setFeature(iterator.next());
                        this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                    }
                    catch (Throwable tr) {
                        this.fireErrorEvent(tr);
                    }
                }
            }
            finally {
                if (collection instanceof FeatureCollection) {
                    FeatureCollection resource = (FeatureCollection)((Object)collection);
                    resource.close(iterator);
                } else if (features != null) {
                    features.close(iterator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOptimized(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection collection, FeatureCollection features, NumberRange scaleRange, ArrayList lfts) {
        Iterator<Object> iterator = null;
        if (collection != null) {
            iterator = collection.iterator();
        }
        if (features != null) {
            iterator = features.iterator();
        }
        if (iterator == null) {
            return;
        }
        LiteFeatureTypeStyle[] fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]);
        try {
            boolean clone = this.isCloningRequired(currLayer, fts_array);
            RenderableFeature rf = new RenderableFeature(currLayer, clone);
            while (iterator.hasNext() && !this.renderingStopRequested) {
                try {
                    rf.setFeature(iterator.next());
                    for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array) {
                        rf.setScreenMap(liteFeatureTypeStyle.screenMap);
                        this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                    }
                }
                catch (Throwable tr) {
                    this.fireErrorEvent(tr);
                }
            }
            this.requests.put(new MergeLayersRequest(graphics, fts_array));
        }
        catch (InterruptedException e) {
            this.fireErrorEvent(e);
        }
        finally {
            if (collection instanceof FeatureCollection) {
                FeatureCollection resource = (FeatureCollection)((Object)collection);
                resource.close(iterator);
            } else if (features != null) {
                features.close(iterator);
            }
        }
    }

    private boolean isCloningRequired(MapLayer layer, LiteFeatureTypeStyle[] lfts) {
        Set<RenderingHints.Key> hints = layer.getFeatureSource().getSupportedHints();
        if (!hints.contains(Hints.FEATURE_DETACHED)) {
            return true;
        }
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        Object featureType = layer.getFeatureSource().getSchema();
        HashSet<String> plainGeometries = new HashSet<String>();
        HashSet<String> txGeometries = new HashSet<String>();
        for (LiteFeatureTypeStyle lft : lfts) {
            for (Rule r : lft.ruleList) {
                for (Symbolizer s : r.symbolizers()) {
                    String attribute;
                    if (s.getGeometry() == null) {
                        attribute = featureType.getGeometryDescriptor().getName().getLocalPart();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    if (s.getGeometry() instanceof PropertyName) {
                        attribute = ((PropertyName)s.getGeometry()).getPropertyName();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    Expression g = s.getGeometry();
                    extractor.clear();
                    g.accept((ExpressionVisitor)extractor, null);
                    Set<String> attributes = extractor.getAttributeNameSet();
                    for (String attribute2 : attributes) {
                        if (plainGeometries.contains(attribute2)) {
                            return true;
                        }
                        if (txGeometries.contains(attribute2)) {
                            return true;
                        }
                        txGeometries.add(attribute2);
                    }
                }
            }
        }
        return false;
    }

    private final void process(RenderableFeature rf, LiteFeatureTypeStyle fts, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws Exception {
        boolean doElse = true;
        Rule[] elseRuleList = fts.elseRules;
        Rule[] ruleList = fts.ruleList;
        Graphics2D graphics = fts.graphics;
        for (Rule r : ruleList) {
            Filter filter = r.getFilter();
            if (filter != null && !filter.evaluate(rf.content)) continue;
            doElse = false;
            this.processSymbolizers(graphics, rf, r.symbolizers(), scaleRange, at, destinationCrs, layerId);
        }
        if (doElse) {
            for (Rule r : elseRuleList) {
                this.processSymbolizers(graphics, rf, r.symbolizers(), scaleRange, at, destinationCrs, layerId);
            }
        }
    }

    private final void processSymbolizers(Graphics2D graphics, RenderableFeature drawMe, List<Symbolizer> symbolizers, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws Exception {
        for (Symbolizer symbolizer : symbolizers) {
            if (symbolizer instanceof RasterSymbolizer) {
                GridCoverage2D coverage = null;
                boolean disposeCoverage = false;
                try {
                    Object grid = gridPropertyName.evaluate(drawMe.content);
                    if (grid instanceof GridCoverage2D) {
                        coverage = (GridCoverage2D)grid;
                    } else if (grid instanceof AbstractGridCoverage2DReader) {
                        Object params = paramsPropertyName.evaluate(drawMe.content);
                        GridGeometry2D readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.screenSize), (org.opengis.geometry.Envelope)this.mapExtent);
                        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)grid;
                        coverage = this.readCoverage(reader, params, readGG);
                        disposeCoverage = true;
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    this.fireErrorEvent(e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    this.fireErrorEvent(e);
                }
                if (coverage == null) continue;
                this.requests.put(new RenderRasterRequest(graphics, coverage, disposeCoverage, (RasterSymbolizer)symbolizer, destinationCrs, at));
                continue;
            }
            LiteShape2 shape = drawMe.getShape(symbolizer, at);
            if (shape == null) continue;
            if (symbolizer instanceof TextSymbolizer && drawMe.content instanceof Feature) {
                this.labelCache.put(layerId, (TextSymbolizer)symbolizer, (Feature)drawMe.content, shape, (NumberRange<Double>)scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(drawMe.content, symbolizer, (Range)scaleRange);
            double size = RendererUtilities.getStyle2DSize(style) + 10.0;
            Envelope env = new Envelope(this.screenSize.getMinX(), this.screenSize.getMaxX(), this.screenSize.getMinY(), this.screenSize.getMaxY());
            env.expandBy(size);
            GeometryClipper clipper = new GeometryClipper(env);
            Geometry g = clipper.clip(shape.getGeometry(), false);
            if (g == null) continue;
            if (g != shape.getGeometry()) {
                shape = new LiteShape2(g, null, null, false);
            }
            this.requests.put(new PaintShapeRequest(graphics, shape, style, this.scaleDenominator));
        }
        this.fireFeatureRenderedEvent(drawMe.content);
    }

    private Geometry findGeometry(Object drawMe, Symbolizer s) {
        Expression geomExpr = s.getGeometry();
        Geometry geom = geomExpr == null ? (drawMe instanceof SimpleFeature ? (Geometry)((SimpleFeature)drawMe).getDefaultGeometry() : (drawMe instanceof Feature ? (Geometry)((Feature)drawMe).getDefaultGeometryProperty().getValue() : (Geometry)defaultGeometryPropertyName.evaluate(drawMe, Geometry.class))) : (Geometry)geomExpr.evaluate(drawMe, Geometry.class);
        return geom;
    }

    private CoordinateReferenceSystem findGeometryCS(MapLayer currLayer, Object drawMe, Symbolizer s) {
        if (drawMe instanceof Feature) {
            Feature f = (Feature)drawMe;
            FeatureType schema = f.getType();
            Expression geometry = s.getGeometry();
            String geomName = null;
            if (geometry instanceof PropertyName) {
                geomName = ((PropertyName)geometry).getPropertyName();
                return this.getAttributeCRS(geomName, schema);
            }
            if (geometry == null) {
                return this.getAttributeCRS(null, schema);
            }
            StyleAttributeExtractor attExtractor = new StyleAttributeExtractor();
            geometry.accept((ExpressionVisitor)attExtractor, null);
            for (String name : attExtractor.getAttributeNameSet()) {
                if (!(schema.getDescriptor(name) instanceof GeometryDescriptor)) continue;
                return this.getAttributeCRS(name, schema);
            }
        } else if (currLayer.getSource() != null) {
            return currLayer.getSource().getCRS();
        }
        return null;
    }

    CoordinateReferenceSystem getAttributeCRS(String geomName, FeatureType schema) {
        if (geomName == null || "".equals(geomName)) {
            GeometryDescriptor geom = schema.getGeometryDescriptor();
            return geom.getType().getCoordinateReferenceSystem();
        }
        GeometryDescriptor geom = (GeometryDescriptor)schema.getDescriptor(geomName);
        return geom.getType().getCoordinateReferenceSystem();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private boolean isOptimizedDataLoadingEnabled() {
        if (this.rendererHints == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        Object result = null;
        try {
            result = this.rendererHints.get(OPTIMIZED_DATA_LOADING_KEY);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (result == null) {
            return this.optimizedDataLoadingEnabledDEFAULT;
        }
        return result;
    }

    private int getRenderingBuffer() {
        if (this.rendererHints == null) {
            return this.renderingBufferDEFAULT;
        }
        Number result = (Number)this.rendererHints.get("renderingBuffer");
        if (result == null) {
            return this.renderingBufferDEFAULT;
        }
        return result.intValue();
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get(SCALE_COMPUTATION_METHOD_KEY);
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    private String getTextRenderingMethod() {
        if (this.rendererHints == null) {
            return this.textRenderingModeDEFAULT;
        }
        String result = (String)this.rendererHints.get(TEXT_RENDERING_KEY);
        if (result == null) {
            return this.textRenderingModeDEFAULT;
        }
        return result;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    @Override
    public void setJava2DHints(RenderingHints hints) {
        this.java2dHints = hints;
        this.styleFactory.setRenderingHints(hints);
    }

    @Override
    public RenderingHints getJava2DHints() {
        return this.java2dHints;
    }

    public void setRendererHints(Map hints) {
        if (hints != null && hints.containsKey(LABEL_CACHE_KEY)) {
            LabelCache cache = (LabelCache)hints.get(LABEL_CACHE_KEY);
            if (cache == null) {
                throw new NullPointerException("Label_Cache_Hint has a null value for the labelcache");
            }
            this.labelCache = cache;
        }
        if (hints != null && hints.containsKey(LINE_WIDTH_OPTIMIZATION_KEY)) {
            this.styleFactory.setLineOptimizationEnabled(Boolean.TRUE.equals(hints.get(LINE_WIDTH_OPTIMIZATION_KEY)));
        }
        this.rendererHints = hints;
        this.styleFactory.setVectorRenderingEnabled(this.isVectorRenderingEnabled());
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    @Override
    public void setContext(MapContext context) {
        this.context = context;
    }

    @Override
    public MapContext getContext() {
        return this.context;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    GridCoverage2D readCoverage(AbstractGridCoverage2DReader reader, Object params, GridGeometry2D readGG) throws IOException {
        GridCoverage2D coverage;
        Parameter readGGParam = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        readGGParam.setValue((Object)readGG);
        if (params != null) {
            GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
            int length = readParams.length;
            if (length > 0) {
                int i;
                String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                }
                if (i < length) {
                    ((Parameter)readParams[i]).setValue((Object)readGGParam);
                    coverage = reader.read(readParams);
                } else {
                    GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                    System.arraycopy(readParams, 0, readParams2, 0, length);
                    readParams2[length] = readGGParam;
                    coverage = reader.read(readParams2);
                }
            } else {
                coverage = reader.read(new GeneralParameterValue[]{readGGParam});
            }
        } else {
            coverage = reader.read(new GeneralParameterValue[]{readGGParam});
        }
        return coverage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PainterThread
    implements Runnable {
        BlockingQueue<RenderingRequest> requests;

        public PainterThread(BlockingQueue<RenderingRequest> requests) {
            this.requests = requests;
        }

        @Override
        public void run() {
            boolean done = false;
            while (!done) {
                try {
                    RenderingRequest request = this.requests.take();
                    if (request instanceof EndRequest || StreamingRenderer.this.renderingStopRequested) {
                        done = true;
                        continue;
                    }
                    request.execute();
                }
                catch (InterruptedException e) {
                    if (!StreamingRenderer.this.renderingStopRequested) continue;
                    done = true;
                }
            }
        }
    }

    class EndRequest
    extends RenderingRequest {
        EndRequest() {
        }

        void execute() {
        }
    }

    public class RenderRasterRequest
    extends RenderingRequest {
        private Graphics2D graphics;
        private boolean disposeCoverage;
        private GridCoverage2D coverage;
        private RasterSymbolizer symbolizer;
        private CoordinateReferenceSystem destinationCRS;
        private AffineTransform worldToScreen;

        public RenderRasterRequest(Graphics2D graphics, GridCoverage2D coverage, boolean disposeCoverage, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, AffineTransform worldToScreen) {
            this.graphics = graphics;
            this.coverage = coverage;
            this.disposeCoverage = disposeCoverage;
            this.symbolizer = symbolizer;
            this.destinationCRS = destinationCRS;
            this.worldToScreen = worldToScreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering Raster " + this.coverage);
            }
            try {
                GridCoverageRenderer gcr = new GridCoverageRenderer(this.destinationCRS, StreamingRenderer.this.originalMapExtent, StreamingRenderer.this.screenSize, this.worldToScreen, StreamingRenderer.this.java2dHints);
                try {
                    gcr.paint(this.graphics, this.coverage, this.symbolizer);
                }
                finally {
                    if (this.coverage != null && this.disposeCoverage) {
                        this.coverage.dispose(true);
                        RenderedImage image = this.coverage.getRenderedImage();
                        if (image instanceof PlanarImage) {
                            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Raster rendered");
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (TransformException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (NoninvertibleTransformException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    class MergeLayersRequest
    extends RenderingRequest {
        Graphics2D graphics;
        LiteFeatureTypeStyle[] fts_array;

        public MergeLayersRequest(Graphics2D graphics, LiteFeatureTypeStyle[] ftsArray) {
            this.graphics = graphics;
            this.fts_array = ftsArray;
        }

        void execute() {
            this.graphics.setComposite(AlphaComposite.getInstance(3));
            for (int t = 0; t < this.fts_array.length; ++t) {
                BufferedImage image;
                Graphics2D ftsGraphics = this.fts_array[t].graphics;
                if (!(ftsGraphics instanceof DelayedBackbufferGraphic) || (image = ((DelayedBackbufferGraphic)ftsGraphics).image) == null) continue;
                this.graphics.drawImage((Image)image, 0, 0, null);
                ftsGraphics.dispose();
            }
        }
    }

    class PaintShapeRequest
    extends RenderingRequest {
        Graphics2D graphic;
        LiteShape2 shape;
        Style2D style;
        double scale;

        public PaintShapeRequest(Graphics2D graphic, LiteShape2 shape, Style2D style, double scale) {
            this.graphic = graphic;
            this.shape = shape;
            this.style = style;
            this.scale = scale;
        }

        void execute() {
            if (this.graphic instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphic).init();
            }
            try {
                StreamingRenderer.this.painter.paint(this.graphic, this.shape, this.style, this.scale);
            }
            catch (Throwable t) {
                StreamingRenderer.this.fireErrorEvent(t);
            }
        }
    }

    abstract class RenderingRequest {
        RenderingRequest() {
        }

        abstract void execute();
    }

    private class RenderableFeature {
        Object content;
        private MapLayer layer;
        private IdentityHashMap symbolizerAssociationHT = new IdentityHashMap();
        private List geometries = new ArrayList();
        private List shapes = new ArrayList();
        private boolean clone;
        private IdentityHashMap decimators = new IdentityHashMap();
        private ScreenMap screenMap;

        public RenderableFeature(MapLayer layer, boolean clone) {
            this.layer = layer;
            this.clone = clone;
        }

        public void setScreenMap(ScreenMap screenMap) {
            this.screenMap = screenMap;
        }

        public void setFeature(Object feature) {
            this.content = feature;
            this.geometries.clear();
            this.shapes.clear();
        }

        public LiteShape2 getShape(Symbolizer symbolizer, AffineTransform at) throws FactoryException {
            Geometry g = StreamingRenderer.this.findGeometry(this.content, symbolizer);
            if (g == null) {
                return null;
            }
            try {
                Envelope env;
                if (this.screenMap != null && !(symbolizer instanceof PointSymbolizer) && !(g instanceof Point) && this.getGeometryIndex(g) == -1 && this.screenMap.canSimplify(env = g.getEnvelopeInternal())) {
                    if (this.screenMap.checkAndSet(env)) {
                        return null;
                    }
                    g = this.screenMap.getSimplifiedShape(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), g.getFactory(), g.getClass());
                }
                SymbolizerAssociation sa = (SymbolizerAssociation)this.symbolizerAssociationHT.get(symbolizer);
                MathTransform2D crsTransform = null;
                MathTransform2D atTransform = null;
                MathTransform2D fullTransform = null;
                if (sa == null) {
                    sa = new SymbolizerAssociation();
                    sa.crs = StreamingRenderer.this.findGeometryCS(this.layer, this.content, symbolizer);
                    try {
                        crsTransform = StreamingRenderer.this.buildTransform(sa.crs, StreamingRenderer.this.destinationCrs);
                        atTransform = (MathTransform2D)ProjectiveTransform.create((AffineTransform)StreamingRenderer.this.worldToScreenTransform);
                        fullTransform = StreamingRenderer.this.buildFullTransform(sa.crs, StreamingRenderer.this.destinationCrs, at);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    sa.xform = fullTransform;
                    sa.crsxform = crsTransform;
                    sa.axform = atTransform;
                    this.symbolizerAssociationHT.put(symbolizer, sa);
                }
                if (symbolizer instanceof PointSymbolizer) {
                    if (!this.clone && g.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory) {
                        LiteShape2 first = this.getTransformedShape(g, sa);
                        if (first != null) {
                            return this.getTransformedShape(RendererUtilities.getCentroid(g), null);
                        }
                        return null;
                    }
                    return this.getTransformedShape(RendererUtilities.getCentroid(g), sa);
                }
                return this.getTransformedShape(g, sa);
            }
            catch (TransformException te) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                StreamingRenderer.this.fireErrorEvent(te);
                return null;
            }
            catch (AssertionError ae) {
                LOGGER.log(Level.FINE, ((Throwable)((Object)ae)).getLocalizedMessage(), (Throwable)((Object)ae));
                StreamingRenderer.this.fireErrorEvent((Throwable)((Object)ae));
                return null;
            }
        }

        private int getGeometryIndex(Geometry g) {
            for (int i = 0; i < this.geometries.size(); ++i) {
                if (this.geometries.get(i) != g) continue;
                return i;
            }
            return -1;
        }

        private final LiteShape2 getTransformedShape(Geometry originalGeom, SymbolizerAssociation sa) throws TransformException, FactoryException {
            LiteShape2 shape;
            int idx = this.getGeometryIndex(originalGeom);
            if (idx != -1) {
                return (LiteShape2)this.shapes.get(idx);
            }
            Geometry geom = originalGeom;
            if (this.clone || !(geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory)) {
                geom = LiteCoordinateSequence.cloneGeometry(geom);
            }
            if (StreamingRenderer.this.projectionHandler != null && sa != null) {
                geom = StreamingRenderer.this.projectionHandler.preProcess(sa.crs, geom);
                if (geom == null) {
                    shape = null;
                } else {
                    Decimator d = this.getDecimator(sa.xform);
                    d.decimateTransformGeneralize(geom, (MathTransform)sa.crsxform);
                    geom.geometryChanged();
                    geom = StreamingRenderer.this.projectionHandler.postProcess(geom);
                    if (geom == null) {
                        shape = null;
                    } else {
                        d = new Decimator(-1.0, -1.0);
                        d.decimateTransformGeneralize(geom, (MathTransform)sa.axform);
                        geom.geometryChanged();
                        shape = new LiteShape2(geom, null, null, false, false);
                    }
                }
            } else {
                MathTransform2D xform = null;
                if (sa != null) {
                    xform = sa.xform;
                }
                shape = new LiteShape2(geom, (MathTransform)xform, this.getDecimator(xform), false, false);
            }
            this.geometries.add(originalGeom);
            this.shapes.add(shape);
            return shape;
        }

        private Decimator getDecimator(MathTransform2D mathTransform) {
            if (StreamingRenderer.this.generalizationDistance == 0.0 || !StreamingRenderer.this.inMemoryGeneralization) {
                return NULL_DECIMATOR;
            }
            Decimator decimator = (Decimator)this.decimators.get(mathTransform);
            if (decimator == null) {
                try {
                    decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator((MathTransform)mathTransform.inverse(), StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance) : new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                catch (org.opengis.referencing.operation.NoninvertibleTransformException e) {
                    decimator = new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                this.decimators.put(mathTransform, decimator);
            }
            return decimator;
        }
    }
}

