/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;

class SimpleGeometryFactory
extends GeometryFactory {
    public SimpleGeometryFactory(CoordinateSequenceFactory csFactory) {
        super(csFactory);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        if (geometries != null && geometries.length == 1) {
            return new CollectionOfOne(geometries, this);
        }
        return super.createGeometryCollection(geometries);
    }

    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        if (lineStrings != null && lineStrings.length == 1) {
            return new SingleLineCollection(lineStrings, (GeometryFactory)this);
        }
        return super.createMultiLineString(lineStrings);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        if (polygons != null && polygons.length == 1) {
            return new SinglePolygonCollection(polygons, (GeometryFactory)this);
        }
        return super.createMultiPolygon(polygons);
    }

    static class SinglePointCollection
    extends MultiPoint {
        Point point;

        public SinglePointCollection(Point[] points, GeometryFactory factory) {
            super(points, factory);
            this.point = points[0];
        }

        public void apply(CoordinateFilter filter) {
            this.point.apply(filter);
        }

        public void apply(CoordinateSequenceFilter filter) {
            this.point.apply(filter);
        }

        public void apply(GeometryComponentFilter filter) {
            this.point.apply(filter);
        }

        public void apply(GeometryFilter filter) {
            this.point.apply(filter);
        }

        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.point.buffer(distance, quadrantSegments, endCapStyle);
        }

        public Geometry buffer(double distance, int quadrantSegments) {
            return this.point.buffer(distance, quadrantSegments);
        }

        public Geometry buffer(double distance) {
            return this.point.buffer(distance);
        }

        public Object clone() {
            return this.point.clone();
        }

        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.point.compareTo(o, comp);
        }

        public int compareTo(Object o) {
            return this.point.compareTo(o);
        }

        public boolean contains(Geometry g) {
            return this.point.contains(g);
        }

        public Geometry convexHull() {
            return this.point.convexHull();
        }

        public boolean coveredBy(Geometry g) {
            return this.point.coveredBy(g);
        }

        public boolean covers(Geometry g) {
            return this.point.covers(g);
        }

        public boolean crosses(Geometry g) {
            return this.point.crosses(g);
        }

        public Geometry difference(Geometry other) {
            return this.point.difference(other);
        }

        public boolean disjoint(Geometry g) {
            return this.point.disjoint(g);
        }

        public double distance(Geometry g) {
            return this.point.distance(g);
        }

        public boolean equals(Geometry g) {
            return this.point.equals(g);
        }

        public boolean equals(Object obj) {
            return this.point.equals(obj);
        }

        public boolean equalsExact(Geometry other, double tolerance) {
            return this.point.equalsExact(other, tolerance);
        }

        public boolean equalsExact(Geometry other) {
            return this.point.equalsExact(other);
        }

        public void geometryChanged() {
            this.point.geometryChanged();
        }

        public double getArea() {
            return this.point.getArea();
        }

        public Geometry getBoundary() {
            return this.point.getBoundary();
        }

        public int getBoundaryDimension() {
            return this.point.getBoundaryDimension();
        }

        public Point getCentroid() {
            return this.point.getCentroid();
        }

        public Coordinate getCoordinate() {
            return this.point.getCoordinate();
        }

        public Coordinate[] getCoordinates() {
            return this.point.getCoordinates();
        }

        public CoordinateSequence getCoordinateSequence() {
            return this.point.getCoordinateSequence();
        }

        public int getDimension() {
            return this.point.getDimension();
        }

        public Geometry getEnvelope() {
            return this.point.getEnvelope();
        }

        public Envelope getEnvelopeInternal() {
            return this.point.getEnvelopeInternal();
        }

        public GeometryFactory getFactory() {
            return this.point.getFactory();
        }

        public Geometry getGeometryN(int n) {
            return this.point.getGeometryN(n);
        }

        public String getGeometryType() {
            return this.point.getGeometryType();
        }

        public Point getInteriorPoint() {
            return this.point.getInteriorPoint();
        }

        public double getLength() {
            return this.point.getLength();
        }

        public int getNumGeometries() {
            return this.point.getNumGeometries();
        }

        public int getNumPoints() {
            return this.point.getNumPoints();
        }

        public PrecisionModel getPrecisionModel() {
            return this.point.getPrecisionModel();
        }

        public int getSRID() {
            return this.point.getSRID();
        }

        public Object getUserData() {
            return this.point.getUserData();
        }

        public double getX() {
            return this.point.getX();
        }

        public double getY() {
            return this.point.getY();
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public Geometry intersection(Geometry other) {
            return this.point.intersection(other);
        }

        public boolean intersects(Geometry g) {
            return this.point.intersects(g);
        }

        public boolean isEmpty() {
            return this.point.isEmpty();
        }

        public boolean isRectangle() {
            return this.point.isRectangle();
        }

        public boolean isSimple() {
            return this.point.isSimple();
        }

        public boolean isValid() {
            return this.point.isValid();
        }

        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.point.isWithinDistance(geom, distance);
        }

        public void normalize() {
            this.point.normalize();
        }

        public boolean overlaps(Geometry g) {
            return this.point.overlaps(g);
        }

        public boolean relate(Geometry g, String intersectionPattern) {
            return this.point.relate(g, intersectionPattern);
        }

        public IntersectionMatrix relate(Geometry g) {
            return this.point.relate(g);
        }

        public Geometry reverse() {
            return this.point.reverse();
        }

        public void setSRID(int SRID) {
            this.point.setSRID(SRID);
        }

        public void setUserData(Object userData) {
            this.point.setUserData(userData);
        }

        public Geometry symDifference(Geometry other) {
            return this.point.symDifference(other);
        }

        public String toString() {
            return this.point.toString();
        }

        public String toText() {
            return this.point.toText();
        }

        public boolean touches(Geometry g) {
            return this.point.touches(g);
        }

        public Geometry union() {
            return this.point.union();
        }

        public Geometry union(Geometry other) {
            return this.point.union(other);
        }

        public boolean within(Geometry g) {
            return this.point.within(g);
        }
    }

    static class SinglePolygonCollection
    extends MultiPolygon {
        Polygon polygon;

        public SinglePolygonCollection(Polygon[] polygons, GeometryFactory factory) {
            super(polygons, factory);
            this.polygon = polygons[0];
        }

        public void apply(CoordinateFilter filter) {
            this.polygon.apply(filter);
        }

        public void apply(CoordinateSequenceFilter filter) {
            this.polygon.apply(filter);
        }

        public void apply(GeometryComponentFilter filter) {
            this.polygon.apply(filter);
        }

        public void apply(GeometryFilter filter) {
            this.polygon.apply(filter);
        }

        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.polygon.buffer(distance, quadrantSegments, endCapStyle);
        }

        public Geometry buffer(double distance, int quadrantSegments) {
            return this.polygon.buffer(distance, quadrantSegments);
        }

        public Geometry buffer(double distance) {
            return this.polygon.buffer(distance);
        }

        public Object clone() {
            return this.polygon.clone();
        }

        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.polygon.compareTo(o, comp);
        }

        public int compareTo(Object o) {
            return this.polygon.compareTo(o);
        }

        public boolean contains(Geometry g) {
            return this.polygon.contains(g);
        }

        public Geometry convexHull() {
            return this.polygon.convexHull();
        }

        public boolean coveredBy(Geometry g) {
            return this.polygon.coveredBy(g);
        }

        public boolean covers(Geometry g) {
            return this.polygon.covers(g);
        }

        public boolean crosses(Geometry g) {
            return this.polygon.crosses(g);
        }

        public Geometry difference(Geometry other) {
            return this.polygon.difference(other);
        }

        public boolean disjoint(Geometry g) {
            return this.polygon.disjoint(g);
        }

        public double distance(Geometry g) {
            return this.polygon.distance(g);
        }

        public boolean equals(Geometry g) {
            return this.polygon.equals(g);
        }

        public boolean equals(Object obj) {
            return this.polygon.equals(obj);
        }

        public boolean equalsExact(Geometry other, double tolerance) {
            return this.polygon.equalsExact(other, tolerance);
        }

        public boolean equalsExact(Geometry other) {
            return this.polygon.equalsExact(other);
        }

        public void geometryChanged() {
            this.polygon.geometryChanged();
        }

        public double getArea() {
            return this.polygon.getArea();
        }

        public Geometry getBoundary() {
            return this.polygon.getBoundary();
        }

        public int getBoundaryDimension() {
            return this.polygon.getBoundaryDimension();
        }

        public Point getCentroid() {
            return this.polygon.getCentroid();
        }

        public Coordinate getCoordinate() {
            return this.polygon.getCoordinate();
        }

        public Coordinate[] getCoordinates() {
            return this.polygon.getCoordinates();
        }

        public int getDimension() {
            return this.polygon.getDimension();
        }

        public Geometry getEnvelope() {
            return this.polygon.getEnvelope();
        }

        public Envelope getEnvelopeInternal() {
            return this.polygon.getEnvelopeInternal();
        }

        public LineString getExteriorRing() {
            return this.polygon.getExteriorRing();
        }

        public GeometryFactory getFactory() {
            return this.polygon.getFactory();
        }

        public Geometry getGeometryN(int n) {
            return this.polygon.getGeometryN(n);
        }

        public String getGeometryType() {
            return this.polygon.getGeometryType();
        }

        public Point getInteriorPoint() {
            return this.polygon.getInteriorPoint();
        }

        public LineString getInteriorRingN(int n) {
            return this.polygon.getInteriorRingN(n);
        }

        public double getLength() {
            return this.polygon.getLength();
        }

        public int getNumGeometries() {
            return this.polygon.getNumGeometries();
        }

        public int getNumInteriorRing() {
            return this.polygon.getNumInteriorRing();
        }

        public int getNumPoints() {
            return this.polygon.getNumPoints();
        }

        public PrecisionModel getPrecisionModel() {
            return this.polygon.getPrecisionModel();
        }

        public int getSRID() {
            return this.polygon.getSRID();
        }

        public Object getUserData() {
            return this.polygon.getUserData();
        }

        public int hashCode() {
            return this.polygon.hashCode();
        }

        public Geometry intersection(Geometry other) {
            return this.polygon.intersection(other);
        }

        public boolean intersects(Geometry g) {
            return this.polygon.intersects(g);
        }

        public boolean isEmpty() {
            return this.polygon.isEmpty();
        }

        public boolean isRectangle() {
            return this.polygon.isRectangle();
        }

        public boolean isSimple() {
            return this.polygon.isSimple();
        }

        public boolean isValid() {
            return this.polygon.isValid();
        }

        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.polygon.isWithinDistance(geom, distance);
        }

        public void normalize() {
            this.polygon.normalize();
        }

        public boolean overlaps(Geometry g) {
            return this.polygon.overlaps(g);
        }

        public boolean relate(Geometry g, String intersectionPattern) {
            return this.polygon.relate(g, intersectionPattern);
        }

        public IntersectionMatrix relate(Geometry g) {
            return this.polygon.relate(g);
        }

        public Geometry reverse() {
            return this.polygon.reverse();
        }

        public void setSRID(int SRID) {
            this.polygon.setSRID(SRID);
        }

        public void setUserData(Object userData) {
            this.polygon.setUserData(userData);
        }

        public Geometry symDifference(Geometry other) {
            return this.polygon.symDifference(other);
        }

        public String toString() {
            return this.polygon.toString();
        }

        public String toText() {
            return this.polygon.toText();
        }

        public boolean touches(Geometry g) {
            return this.polygon.touches(g);
        }

        public Geometry union() {
            return this.polygon.union();
        }

        public Geometry union(Geometry other) {
            return this.polygon.union(other);
        }

        public boolean within(Geometry g) {
            return this.polygon.within(g);
        }
    }

    static class SingleLineCollection
    extends MultiLineString {
        LineString lineString;

        public SingleLineCollection(LineString[] lineStrings, GeometryFactory factory) {
            super(lineStrings, factory);
            this.lineString = lineStrings[0];
        }

        public void apply(CoordinateFilter filter) {
            this.lineString.apply(filter);
        }

        public void apply(CoordinateSequenceFilter filter) {
            this.lineString.apply(filter);
        }

        public void apply(GeometryComponentFilter filter) {
            this.lineString.apply(filter);
        }

        public void apply(GeometryFilter filter) {
            this.lineString.apply(filter);
        }

        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.lineString.buffer(distance, quadrantSegments, endCapStyle);
        }

        public Geometry buffer(double distance, int quadrantSegments) {
            return this.lineString.buffer(distance, quadrantSegments);
        }

        public Geometry buffer(double distance) {
            return this.lineString.buffer(distance);
        }

        public Object clone() {
            return this.lineString.clone();
        }

        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.lineString.compareTo(o, comp);
        }

        public int compareTo(Object o) {
            return this.lineString.compareTo(o);
        }

        public boolean contains(Geometry g) {
            return this.lineString.contains(g);
        }

        public Geometry convexHull() {
            return this.lineString.convexHull();
        }

        public boolean coveredBy(Geometry g) {
            return this.lineString.coveredBy(g);
        }

        public boolean covers(Geometry g) {
            return this.lineString.covers(g);
        }

        public boolean crosses(Geometry g) {
            return this.lineString.crosses(g);
        }

        public Geometry difference(Geometry other) {
            return this.lineString.difference(other);
        }

        public boolean disjoint(Geometry g) {
            return this.lineString.disjoint(g);
        }

        public double distance(Geometry g) {
            return this.lineString.distance(g);
        }

        public boolean equals(Geometry g) {
            return this.lineString.equals(g);
        }

        public boolean equals(Object obj) {
            return this.lineString.equals(obj);
        }

        public boolean equalsExact(Geometry other, double tolerance) {
            return this.lineString.equalsExact(other, tolerance);
        }

        public boolean equalsExact(Geometry other) {
            return this.lineString.equalsExact(other);
        }

        public void geometryChanged() {
            this.lineString.geometryChanged();
        }

        public double getArea() {
            return this.lineString.getArea();
        }

        public Geometry getBoundary() {
            return this.lineString.getBoundary();
        }

        public int getBoundaryDimension() {
            return this.lineString.getBoundaryDimension();
        }

        public Point getCentroid() {
            return this.lineString.getCentroid();
        }

        public Coordinate getCoordinate() {
            return this.lineString.getCoordinate();
        }

        public Coordinate getCoordinateN(int n) {
            return this.lineString.getCoordinateN(n);
        }

        public Coordinate[] getCoordinates() {
            return this.lineString.getCoordinates();
        }

        public CoordinateSequence getCoordinateSequence() {
            return this.lineString.getCoordinateSequence();
        }

        public int getDimension() {
            return this.lineString.getDimension();
        }

        public Point getEndPoint() {
            return this.lineString.getEndPoint();
        }

        public Geometry getEnvelope() {
            return this.lineString.getEnvelope();
        }

        public Envelope getEnvelopeInternal() {
            return this.lineString.getEnvelopeInternal();
        }

        public GeometryFactory getFactory() {
            return this.lineString.getFactory();
        }

        public Geometry getGeometryN(int n) {
            return this.lineString.getGeometryN(n);
        }

        public String getGeometryType() {
            return this.lineString.getGeometryType();
        }

        public Point getInteriorPoint() {
            return this.lineString.getInteriorPoint();
        }

        public double getLength() {
            return this.lineString.getLength();
        }

        public int getNumGeometries() {
            return this.lineString.getNumGeometries();
        }

        public int getNumPoints() {
            return this.lineString.getNumPoints();
        }

        public Point getPointN(int n) {
            return this.lineString.getPointN(n);
        }

        public PrecisionModel getPrecisionModel() {
            return this.lineString.getPrecisionModel();
        }

        public int getSRID() {
            return this.lineString.getSRID();
        }

        public Point getStartPoint() {
            return this.lineString.getStartPoint();
        }

        public Object getUserData() {
            return this.lineString.getUserData();
        }

        public int hashCode() {
            return this.lineString.hashCode();
        }

        public Geometry intersection(Geometry other) {
            return this.lineString.intersection(other);
        }

        public boolean intersects(Geometry g) {
            return this.lineString.intersects(g);
        }

        public boolean isClosed() {
            return this.lineString.isClosed();
        }

        public boolean isCoordinate(Coordinate pt) {
            return this.lineString.isCoordinate(pt);
        }

        public boolean isEmpty() {
            return this.lineString.isEmpty();
        }

        public boolean isRectangle() {
            return this.lineString.isRectangle();
        }

        public boolean isRing() {
            return this.lineString.isRing();
        }

        public boolean isSimple() {
            return this.lineString.isSimple();
        }

        public boolean isValid() {
            return this.lineString.isValid();
        }

        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.lineString.isWithinDistance(geom, distance);
        }

        public void normalize() {
            this.lineString.normalize();
        }

        public boolean overlaps(Geometry g) {
            return this.lineString.overlaps(g);
        }

        public boolean relate(Geometry g, String intersectionPattern) {
            return this.lineString.relate(g, intersectionPattern);
        }

        public IntersectionMatrix relate(Geometry g) {
            return this.lineString.relate(g);
        }

        public Geometry reverse() {
            return this.lineString.reverse();
        }

        public void setSRID(int SRID) {
            this.lineString.setSRID(SRID);
        }

        public void setUserData(Object userData) {
            this.lineString.setUserData(userData);
        }

        public Geometry symDifference(Geometry other) {
            return this.lineString.symDifference(other);
        }

        public String toString() {
            return this.lineString.toString();
        }

        public String toText() {
            return this.lineString.toText();
        }

        public boolean touches(Geometry g) {
            return this.lineString.touches(g);
        }

        public Geometry union() {
            return this.lineString.union();
        }

        public Geometry union(Geometry other) {
            return this.lineString.union(other);
        }

        public boolean within(Geometry g) {
            return this.lineString.within(g);
        }
    }

    static class CollectionOfOne
    extends GeometryCollection {
        Geometry geometry;

        public CollectionOfOne(Geometry[] geometries, GeometryFactory factory) {
            super(geometries, factory);
            this.geometry = geometries[0];
        }

        public void apply(CoordinateFilter filter) {
            this.geometry.apply(filter);
        }

        public void apply(CoordinateSequenceFilter filter) {
            this.geometry.apply(filter);
        }

        public void apply(GeometryComponentFilter filter) {
            this.geometry.apply(filter);
        }

        public void apply(GeometryFilter filter) {
            this.geometry.apply(filter);
        }

        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.geometry.buffer(distance, quadrantSegments, endCapStyle);
        }

        public Geometry buffer(double distance, int quadrantSegments) {
            return this.geometry.buffer(distance, quadrantSegments);
        }

        public Geometry buffer(double distance) {
            return this.geometry.buffer(distance);
        }

        public Object clone() {
            return this.geometry.clone();
        }

        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.geometry.compareTo(o, comp);
        }

        public int compareTo(Object o) {
            return this.geometry.compareTo(o);
        }

        public boolean contains(Geometry g) {
            return this.geometry.contains(g);
        }

        public Geometry convexHull() {
            return this.geometry.convexHull();
        }

        public boolean coveredBy(Geometry g) {
            return this.geometry.coveredBy(g);
        }

        public boolean covers(Geometry g) {
            return this.geometry.covers(g);
        }

        public boolean crosses(Geometry g) {
            return this.geometry.crosses(g);
        }

        public Geometry difference(Geometry other) {
            return this.geometry.difference(other);
        }

        public boolean disjoint(Geometry g) {
            return this.geometry.disjoint(g);
        }

        public double distance(Geometry g) {
            return this.geometry.distance(g);
        }

        public boolean equals(Geometry g) {
            return this.geometry.equals(g);
        }

        public boolean equals(Object obj) {
            return this.geometry.equals(obj);
        }

        public boolean equalsExact(Geometry other, double tolerance) {
            return this.geometry.equalsExact(other, tolerance);
        }

        public boolean equalsExact(Geometry other) {
            return this.geometry.equalsExact(other);
        }

        public void geometryChanged() {
            this.geometry.geometryChanged();
        }

        public double getArea() {
            return this.geometry.getArea();
        }

        public Geometry getBoundary() {
            return this.geometry.getBoundary();
        }

        public int getBoundaryDimension() {
            return this.geometry.getBoundaryDimension();
        }

        public Point getCentroid() {
            return this.geometry.getCentroid();
        }

        public Coordinate getCoordinate() {
            return this.geometry.getCoordinate();
        }

        public Coordinate[] getCoordinates() {
            return this.geometry.getCoordinates();
        }

        public int getDimension() {
            return this.geometry.getDimension();
        }

        public Geometry getEnvelope() {
            return this.geometry.getEnvelope();
        }

        public Envelope getEnvelopeInternal() {
            return this.geometry.getEnvelopeInternal();
        }

        public GeometryFactory getFactory() {
            return this.geometry.getFactory();
        }

        public Geometry getGeometryN(int n) {
            return this.geometry.getGeometryN(n);
        }

        public String getGeometryType() {
            return this.geometry.getGeometryType();
        }

        public Point getInteriorPoint() {
            return this.geometry.getInteriorPoint();
        }

        public double getLength() {
            return this.geometry.getLength();
        }

        public int getNumGeometries() {
            return this.geometry.getNumGeometries();
        }

        public int getNumPoints() {
            return this.geometry.getNumPoints();
        }

        public PrecisionModel getPrecisionModel() {
            return this.geometry.getPrecisionModel();
        }

        public int getSRID() {
            return this.geometry.getSRID();
        }

        public Object getUserData() {
            return this.geometry.getUserData();
        }

        public int hashCode() {
            return this.geometry.hashCode();
        }

        public Geometry intersection(Geometry other) {
            return this.geometry.intersection(other);
        }

        public boolean intersects(Geometry g) {
            return this.geometry.intersects(g);
        }

        public boolean isEmpty() {
            return this.geometry.isEmpty();
        }

        public boolean isRectangle() {
            return this.geometry.isRectangle();
        }

        public boolean isSimple() {
            return this.geometry.isSimple();
        }

        public boolean isValid() {
            return this.geometry.isValid();
        }

        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.geometry.isWithinDistance(geom, distance);
        }

        public void normalize() {
            this.geometry.normalize();
        }

        public boolean overlaps(Geometry g) {
            return this.geometry.overlaps(g);
        }

        public boolean relate(Geometry g, String intersectionPattern) {
            return this.geometry.relate(g, intersectionPattern);
        }

        public IntersectionMatrix relate(Geometry g) {
            return this.geometry.relate(g);
        }

        public Geometry reverse() {
            return this.geometry.reverse();
        }

        public void setSRID(int SRID) {
            this.geometry.setSRID(SRID);
        }

        public void setUserData(Object userData) {
            this.geometry.setUserData(userData);
        }

        public Geometry symDifference(Geometry other) {
            return this.geometry.symDifference(other);
        }

        public String toString() {
            return this.geometry.toString();
        }

        public String toText() {
            return this.geometry.toText();
        }

        public boolean touches(Geometry g) {
            return this.geometry.touches(g);
        }

        public Geometry union() {
            return this.geometry.union();
        }

        public Geometry union(Geometry other) {
            return this.geometry.union(other);
        }

        public boolean within(Geometry g) {
            return this.geometry.within(g);
        }
    }
}

