/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map.direct;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.util.Converters;

public class MessageDirectLayer
extends DirectLayer {
    private String message;
    private static final String COLOR = "color";
    public static final String X = "x";
    public static final String Y = "y";

    public MessageDirectLayer(String message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
        if (viewport == null) {
            viewport = map.getViewport();
        }
        if (viewport == null || viewport.getScreenArea() == null) {
            return;
        }
        if (this.message == null || this.message.length() == 0) {
            return;
        }
        Rectangle2D screen = MessageDirectLayer.rectangle2D(viewport.getScreenArea());
        Double dx = Converters.convert(this.getUserData().get(X), Double.class);
        Double dy = Converters.convert(this.getUserData().get(Y), Double.class);
        if (dx == null) {
            dx = screen.getWidth();
        }
        if (dy == null) {
            dy = screen.getHeight();
        }
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D text = fm.getStringBounds(this.message, graphics);
        double x = MessageDirectLayer.position(screen.getX(), screen.getWidth(), dx, text.getWidth());
        double y = MessageDirectLayer.position(screen.getY(), screen.getHeight(), dy, text.getHeight());
        Color color = Converters.convert(this.getUserData().get(COLOR), Color.class);
        Color previousColor = graphics.getColor();
        try {
            if (color != null) {
                graphics.setColor(color);
            }
            graphics.drawString(this.message, (float)x, (float)y);
        }
        finally {
            if (color != null) {
                graphics.setColor(previousColor);
            }
        }
    }

    static double position(double x, double width, double dx, double span) {
        double ratio = dx / width;
        if (ratio < 0.3) {
            return x + dx;
        }
        if (ratio > 0.7) {
            return x + dx - span;
        }
        return x + dx - span / 2.0;
    }

    static Rectangle2D rectangle2D(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        return new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public ReferencedEnvelope getBounds() {
        return null;
    }
}

