/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;

public class ExtensionFileFilter
implements FileFilter,
Serializable {
    String[] extensions;

    public ExtensionFileFilter(String ... extensions) {
        this.extensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            this.extensions[i] = extensions[i].toUpperCase();
        }
    }

    public boolean accept(File pathname) {
        if (pathname.isFile()) {
            String name = pathname.getName().toUpperCase();
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
        if (!pathname.isDirectory()) {
            return false;
        }
        return !pathname.isHidden();
    }
}

