/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

public class XMLNameValidator
extends AbstractValidator {
    private static Pattern XML_NAME_PATTERN;

    protected void onValidate(IValidatable validatable) {
        String value = (String)validatable.getValue();
        if (!XML_NAME_PATTERN.matcher(value).matches()) {
            this.error(validatable, "invalidXMLName", Collections.singletonMap("name", value));
        }
    }

    static {
        String nameStartCharSet = "A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f\u1fff\u200c\u200d\u2070-\u218f\u2c00\u2fef\u3001\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
        String nameStartChar = "[" + nameStartCharSet + "]";
        String nameChar = "[" + nameStartCharSet + "\\-.0-9\u0087\u0300-\u036f\u203f-\u2040]";
        String name = "(?:" + nameStartChar + nameChar + "*)";
        XML_NAME_PATTERN = Pattern.compile(name, 2);
    }
}

