/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geotools.util.Converters;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class FileExistsValidator
extends AbstractValidator {
    private UrlValidator delegate;

    public FileExistsValidator() {
        this(true);
    }

    public FileExistsValidator(boolean allowRemoteUrl) {
        if (allowRemoteUrl) {
            this.delegate = new UrlValidator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onValidate(IValidatable validatable) {
        String uriSpec = (String)Converters.convert((Object)validatable.getValue(), String.class);
        try {
            URI uri = new URI(uriSpec);
            if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                if (this.delegate != null) {
                    this.delegate.validate(validatable);
                    InputStream is = null;
                    try {
                        URLConnection connection = uri.toURL().openConnection();
                        connection.setConnectTimeout(10000);
                        is = connection.getInputStream();
                    }
                    catch (Exception e) {
                        try {
                            this.error(validatable, "FileExistsValidator.unreachable", Collections.singletonMap("file", uriSpec));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                return;
            }
            String path = uri.getPath();
            if (path != null && new File(path).exists()) {
                return;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        File relFile = GeoserverDataDirectory.findDataFile((String)uriSpec);
        if (relFile == null || !relFile.exists()) {
            this.error(validatable, "FileExistsValidator.fileNotFoundError", Collections.singletonMap("file", uriSpec));
        }
    }
}

