/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SRSListPanel;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSPanel
extends FormComponentPanel {
    private static Logger LOGGER = Logging.getLogger(CRSPanel.class);
    private static final long serialVersionUID = -6677103383336166008L;
    private static IBehavior READ_ONLY = new AttributeModifier("readonly", true, (IModel)new Model((Serializable)((Object)"readonly")));
    ModalWindow popupWindow;
    TextField srsTextField;
    AjaxLink findLink;
    Label wktLabel;
    GeoServerAjaxFormLink wktLink;

    public CRSPanel(String id) {
        super(id);
        this.initComponents();
    }

    public CRSPanel(String id, IModel model) {
        super(id, model);
        this.initComponents();
    }

    public CRSPanel(String id, CoordinateReferenceSystem crs) {
        super(id, (IModel)new Model((Serializable)crs));
        this.initComponents();
        this.setConvertedInput(crs);
    }

    void initComponents() {
        this.popupWindow = new ModalWindow("popup");
        this.add(new Component[]{this.popupWindow});
        this.srsTextField = new TextField("srs", (IModel)new Model());
        this.add(new Component[]{this.srsTextField});
        this.srsTextField.setOutputMarkupId(true);
        this.srsTextField.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

            protected void onUpdate(AjaxRequestTarget target) {
                CRSPanel.this.convertInput();
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)CRSPanel.this.getConvertedInput();
                if (crs != null) {
                    CRSPanel.this.setModelObject(crs);
                    CRSPanel.this.wktLabel.setDefaultModelObject((Object)crs.getName().toString());
                    CRSPanel.this.wktLink.setEnabled(true);
                } else {
                    CRSPanel.this.wktLabel.setDefaultModelObject(null);
                    CRSPanel.this.wktLink.setEnabled(false);
                }
                target.addComponent((Component)CRSPanel.this.wktLink);
            }
        }});
        this.findLink = new AjaxLink("find"){

            public void onClick(AjaxRequestTarget target) {
                CRSPanel.this.popupWindow.setContent((Component)CRSPanel.this.srsListPanel());
                CRSPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("selectSRS", (Component)CRSPanel.this, new Object[0]));
                CRSPanel.this.popupWindow.show(target);
            }
        };
        this.add(new Component[]{this.findLink});
        this.wktLink = new GeoServerAjaxFormLink("wkt"){

            public void onClick(AjaxRequestTarget target, Form form) {
                CRSPanel.this.popupWindow.setInitialHeight(375);
                CRSPanel.this.popupWindow.setInitialWidth(525);
                CRSPanel.this.popupWindow.setContent((Component)new WKTPanel(CRSPanel.this.popupWindow.getContentId(), CRSPanel.this.getCRS()));
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)CRSPanel.this.getModelObject();
                if (crs != null) {
                    CRSPanel.this.popupWindow.setTitle(crs.getName().toString());
                }
                CRSPanel.this.popupWindow.show(target);
            }
        };
        this.wktLink.setEnabled(this.getModelObject() != null);
        this.add(new Component[]{this.wktLink});
        this.wktLabel = new Label("wktLabel", (IModel)new Model());
        this.wktLink.add(new Component[]{this.wktLabel});
        this.wktLabel.setOutputMarkupId(true);
    }

    protected void onBeforeRender() {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.getModelObject();
        if (crs != null) {
            this.srsTextField.setModelObject((Object)this.toSRS(crs));
            this.wktLabel.setDefaultModelObject((Object)crs.getName().toString());
        } else {
            this.wktLabel.setDefaultModelObject(null);
            this.wktLink.setEnabled(false);
        }
        super.onBeforeRender();
    }

    protected void convertInput() {
        String srs = this.srsTextField.getInput();
        CoordinateReferenceSystem crs = null;
        if (srs != null && !"".equals(srs)) {
            if ("UNKNOWN".equals(srs)) {
                if (this.getModelObject() instanceof CoordinateReferenceSystem) {
                    this.setConvertedInput(this.getModelObject());
                }
                return;
            }
            crs = this.fromSRS(srs);
        }
        this.setConvertedInput(crs);
    }

    public CRSPanel setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.srsTextField.add(new IBehavior[]{READ_ONLY});
        } else {
            this.srsTextField.remove(READ_ONLY);
        }
        this.findLink.setVisible(!readOnly);
        return this;
    }

    public CoordinateReferenceSystem getCRS() {
        this.convertInput();
        return (CoordinateReferenceSystem)this.getConvertedInput();
    }

    String toSRS(CoordinateReferenceSystem crs) {
        try {
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            return epsgCode != null ? "EPSG:" + epsgCode : "UNKNOWN";
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not succesffully lookup an EPSG code", e);
            return null;
        }
    }

    CoordinateReferenceSystem fromSRS(String srs) {
        try {
            return CRS.decode((String)srs);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unknown EPSG code " + srs, e);
            return null;
        }
    }

    SRSListPanel srsListPanel() {
        SRSListPanel srsList = new SRSListPanel(this.popupWindow.getContentId()){

            protected void onCodeClicked(AjaxRequestTarget target, String epsgCode) {
                CRSPanel.this.popupWindow.close(target);
                String srs = "EPSG:" + epsgCode;
                CRSPanel.this.srsTextField.setModelObject((Object)srs);
                target.addComponent((Component)CRSPanel.this.srsTextField);
                CoordinateReferenceSystem crs = CRSPanel.this.fromSRS(srs);
                CRSPanel.this.wktLabel.setDefaultModelObject((Object)crs.getName().toString());
                CRSPanel.this.wktLink.setEnabled(true);
                target.addComponent((Component)CRSPanel.this.wktLink);
            }
        };
        srsList.setCompactMode(true);
        return srsList;
    }

    public static class WKTPanel
    extends Panel {
        public WKTPanel(String id, CoordinateReferenceSystem crs) {
            super(id);
            MultiLineLabel wktLabel = new MultiLineLabel("wkt");
            this.add(new Component[]{wktLabel});
            if (crs != null) {
                wktLabel.setDefaultModel((IModel)new Model((Serializable)((Object)crs.toString())));
            }
        }
    }
}

