/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.model.IModel;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSModel
implements IModel {
    transient CoordinateReferenceSystem crs;
    String wkt;

    public CRSModel(CoordinateReferenceSystem crs) {
        this.setObject(crs);
    }

    public CoordinateReferenceSystem getObject() {
        if (this.crs != null) {
            return this.crs;
        }
        try {
            this.crs = CRS.parseWKT((String)this.wkt);
            return this.crs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setObject(Object object) {
        this.crs = (CoordinateReferenceSystem)object;
        this.wkt = this.crs != null ? this.crs.toWKT() : null;
    }

    public void detach() {
        this.crs = null;
    }
}

