/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import javax.management.RuntimeErrorException;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractWMSStorePage;
import org.geotools.data.wms.WebMapServer;

public class WMSStoreNewPage
extends AbstractWMSStorePage {
    public WMSStoreNewPage() {
        try {
            CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo store = builder.buildWMSStore(null);
            this.initUI(store);
            this.capabilitiesURL.getFormComponent().add((IValidator)new WMSCapabilitiesURLValidator());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not setup the WMS store: " + e.getMessage(), e);
        }
    }

    protected void onSave(WMSStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        NewLayerPage layerChooserPage;
        WMSStoreInfo savedStore = this.getCatalog().getFactory().createWebMapServer();
        this.clone(info, savedStore);
        try {
            this.getCatalog().save((StoreInfo)savedStore);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Adding the store for " + info.getCapabilitiesURL(), e);
            throw new IllegalArgumentException("The WMS store could not be saved. Failure message: " + e.getMessage());
        }
        try {
            layerChooserPage = new NewLayerPage(savedStore.getId());
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Getting list of layers for the WMS store " + info.getCapabilitiesURL(), e);
            try {
                this.getCatalog().remove((StoreInfo)savedStore);
            }
            catch (RuntimeErrorException shouldNotHappen) {
                LOGGER.log(Level.WARNING, "Can't remove CoverageStoreInfo after adding it!", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.setResponsePage((Page)layerChooserPage);
    }

    static final class WMSCapabilitiesURLValidator
    extends AbstractValidator {
        WMSCapabilitiesURLValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String url = (String)validatable.getValue();
            try {
                WebMapServer server = new WebMapServer(new URL(url));
                server.getCapabilities();
            }
            catch (Exception e) {
                this.error(validatable, "WMSCapabilitiesValidator.connectionFailure", Collections.singletonMap("error", e.getMessage()));
            }
        }
    }
}

