/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geoserver.web.data.store.CheckExistingResourcesInWorkspaceValidator;
import org.geoserver.web.data.store.StoreConnectionFailedInformationPanel;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.DataAccess;

public class DataAccessEditPage
extends AbstractDataAccessPage
implements Serializable {
    public static final String STORE_NAME = "storeName";
    public static final String WS_NAME = "wsName";
    private GeoServerDialog dialog;

    public DataAccessEditPage(PageParameters parameters) {
        String wsName = parameters.getString(WS_NAME);
        String storeName = parameters.getString(STORE_NAME);
        DataStoreInfo dsi = this.getCatalog().getDataStoreByName(wsName, storeName);
        if (dsi == null) {
            this.error((Serializable)((Object)new ParamResourceModel("DataAccessEditPage.notFound", (Component)this, wsName, storeName).getString()));
            this.setResponsePage(StorePage.class);
            return;
        }
        try {
            this.initUI(dsi);
        }
        catch (IllegalArgumentException e) {
            this.error((Serializable)((Object)e.getMessage()));
            this.setResponsePage(StorePage.class);
            return;
        }
    }

    public DataAccessEditPage(String dataStoreInfoId) throws IllegalArgumentException {
        Catalog catalog = this.getCatalog();
        DataStoreInfo dataStoreInfo = catalog.getDataStore(dataStoreInfoId);
        if (null == dataStoreInfo) {
            throw new IllegalArgumentException("DataStore " + dataStoreInfoId + " not found");
        }
        this.initUI(dataStoreInfo);
    }

    protected void initUI(DataStoreInfo dataStoreInfo) {
        this.dialog = new GeoServerDialog("dialog");
        this.add(new Component[]{this.dialog});
        super.initUI(dataStoreInfo);
        String wsId = dataStoreInfo.getWorkspace().getId();
        this.workspacePanel.getFormComponent().add((IValidator)new CheckExistingResourcesInWorkspaceValidator(dataStoreInfo.getId(), wsId));
    }

    protected final void onSaveDataStore(DataStoreInfo info, AjaxRequestTarget requestTarget) {
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        resourcePool.clear(info);
        if (info.isEnabled()) {
            try {
                DataAccess dataStore = catalog.getResourcePool().getDataStore(info);
                LOGGER.finer("connection parameters verified for store " + info.getName() + ". Got a " + dataStore.getClass().getName());
                this.doSaveStore(info);
                this.setResponsePage(StorePage.class);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error obtaining datastore with the modified values", e);
                this.confirmSaveOnConnectionFailure(info, requestTarget, e);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error obtaining datastore with the modified values", e);
                this.confirmSaveOnConnectionFailure(info, requestTarget, e);
            }
        } else {
            this.doSaveStore(info);
            this.setResponsePage(StorePage.class);
        }
    }

    private void confirmSaveOnConnectionFailure(final DataStoreInfo info, AjaxRequestTarget requestTarget, Exception error) {
        this.getCatalog().getResourcePool().clear(info);
        String message = error.getMessage();
        if (message == null && error.getCause() != null) {
            message = error.getCause().getMessage();
        }
        final String exceptionMessage = message;
        this.dialog.showOkCancel(requestTarget, new GeoServerDialog.DialogDelegate(){
            boolean accepted = false;

            protected Component getContents(String id) {
                return new StoreConnectionFailedInformationPanel(id, info.getName(), exceptionMessage);
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                DataAccessEditPage.this.doSaveStore(info);
                this.accepted = true;
                return true;
            }

            protected boolean onCancel(AjaxRequestTarget target) {
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (this.accepted) {
                    DataAccessEditPage.this.setResponsePage(StorePage.class);
                }
            }
        });
    }

    private void doSaveStore(DataStoreInfo info) {
        try {
            Catalog catalog = this.getCatalog();
            NamespaceInfo namespace = catalog.getNamespaceByPrefix(info.getWorkspace().getName());
            List configuredResources = catalog.getResourcesByStore((StoreInfo)info, FeatureTypeInfo.class);
            for (FeatureTypeInfo alreadyConfigured : configuredResources) {
                alreadyConfigured.setNamespace(namespace);
            }
            ResourcePool resourcePool = catalog.getResourcePool();
            resourcePool.clear(info);
            catalog.save((StoreInfo)info);
            for (FeatureTypeInfo alreadyConfigured : configuredResources) {
                catalog.save((ResourceInfo)alreadyConfigured);
            }
            LOGGER.finer("Saved store " + info.getName());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error saving data store to catalog", e);
            throw new IllegalArgumentException("Error saving data store:" + e.getMessage());
        }
    }
}

