/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layer.SQLViewEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geotools.jdbc.VirtualTable;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public class FeatureResourceConfigurationPanel
extends ResourceConfigurationPanel {
    ModalWindow reloadWarningDialog;

    public FeatureResourceConfigurationPanel(String id, final IModel model) {
        super(id, model);
        final Fragment attributePanel = new Fragment("attributePanel", "attributePanelFragment", (MarkupContainer)this);
        attributePanel.setOutputMarkupId(true);
        this.add(new Component[]{attributePanel});
        ListView attributes = new ListView("attributes", (IModel)new Model(){

            public Serializable getObject() {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                try {
                    ResourcePool resourcePool = GeoServerApplication.get().getCatalog().getResourcePool();
                    return (Serializable)((Object)resourcePool.getAttributes(typeInfo));
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        }){

            protected void populateItem(ListItem item) {
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd"))});
                AttributeTypeInfo attribute = (AttributeTypeInfo)item.getModelObject();
                item.add(new Component[]{new Label("name", attribute.getName())});
                item.add(new Component[]{new Label("minmax", attribute.getMinOccurs() + "/" + attribute.getMaxOccurs())});
                try {
                    FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                    ResourcePool resourcePool = GeoServerApplication.get().getCatalog().getResourcePool();
                    FeatureType featureType = resourcePool.getFeatureType(typeInfo);
                    PropertyDescriptor pd = featureType.getDescriptor(attribute.getName());
                    String typeName = "?";
                    String nillable = "?";
                    try {
                        typeName = pd.getType().getBinding().getSimpleName();
                        nillable = String.valueOf(pd.isNillable());
                    }
                    catch (Exception e) {
                        ResourceConfigurationPanel.LOGGER.log(Level.INFO, "Could not find attribute " + attribute.getName() + " in feature type " + featureType, e);
                    }
                    item.add(new Component[]{new Label("type", typeName)});
                    item.add(new Component[]{new Label("nillable", nillable)});
                }
                catch (IOException e) {
                    item.add(new Component[]{new Label("type", "?")});
                    item.add(new Component[]{new Label("nillable", "?")});
                }
            }
        };
        attributePanel.add(new Component[]{attributes});
        WebMarkupContainer reloadContainer = new WebMarkupContainer("reloadContainer");
        attributePanel.add(new Component[]{reloadContainer});
        GeoServerAjaxFormLink reload = new GeoServerAjaxFormLink("reload"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                GeoServerApplication app = (GeoServerApplication)this.getApplication();
                FeatureTypeInfo ft = (FeatureTypeInfo)FeatureResourceConfigurationPanel.this.getResourceInfo();
                app.getCatalog().getResourcePool().clear(ft);
                app.getCatalog().getResourcePool().clear(ft.getStore());
                target.addComponent((Component)attributePanel);
            }
        };
        reloadContainer.add(new Component[]{reload});
        GeoServerAjaxFormLink warning = new GeoServerAjaxFormLink("reloadWarning"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                FeatureResourceConfigurationPanel.this.reloadWarningDialog.show(target);
            }
        };
        reloadContainer.add(new Component[]{warning});
        Component[] componentArray = new Component[1];
        this.reloadWarningDialog = new ModalWindow("reloadWarningDialog");
        componentArray[0] = this.reloadWarningDialog;
        this.add(componentArray);
        this.reloadWarningDialog.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new ReloadWarningDialog(new StringResourceModel("featureTypeReloadWarning", (Component)FeatureResourceConfigurationPanel.this, null));
            }
        });
        this.reloadWarningDialog.setTitle((IModel)new StringResourceModel("warning", (Component)null, null));
        this.reloadWarningDialog.setInitialHeight(100);
        this.reloadWarningDialog.setInitialHeight(200);
        WebMarkupContainer sqlViewContainer = new WebMarkupContainer("editSqlContainer");
        attributePanel.add(new Component[]{sqlViewContainer});
        sqlViewContainer.add(new Component[]{new Link("editSql"){

            public void onClick() {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                try {
                    this.setResponsePage((Page)new SQLViewEditPage(typeInfo, (ResourceConfigurationPage)this.getPage()));
                }
                catch (Exception e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Failure opening the sql view edit page", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        }});
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
        reloadContainer.setVisible(typeInfo.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class) == null);
        sqlViewContainer.setVisible(!reloadContainer.isVisible());
    }

    static class ReloadWarningDialog
    extends WebPage {
        public ReloadWarningDialog(StringResourceModel message) {
            this.add(new Component[]{new Label("message", (IModel)message)});
        }
    }
}

