/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.web.data.layer.SQLViewAttribute;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLViewAttributeProvider
extends GeoServerDataProvider<SQLViewAttribute> {
    static final Logger LOGGER = Logging.getLogger(SQLViewAttribute.class);
    static final GeoServerDataProvider.Property<SQLViewAttribute> NAME = new GeoServerDataProvider.BeanProperty<SQLViewAttribute>("name", "name");
    static final GeoServerDataProvider.Property<SQLViewAttribute> TYPE = new GeoServerDataProvider.AbstractProperty<SQLViewAttribute>("type"){

        @Override
        public Object getPropertyValue(SQLViewAttribute item) {
            if (item.getType() != null) {
                return item.getType().getSimpleName();
            }
            return null;
        }
    };
    static final GeoServerDataProvider.Property<SQLViewAttribute> SRID = new GeoServerDataProvider.BeanProperty<SQLViewAttribute>("srid", "srid");
    static final GeoServerDataProvider.Property<SQLViewAttribute> PK = new GeoServerDataProvider.BeanProperty<SQLViewAttribute>("pk", "pk");
    List<SQLViewAttribute> attributes = new ArrayList<SQLViewAttribute>();

    public SQLViewAttributeProvider() {
        this.setEditable(true);
    }

    void setFeatureType(SimpleFeatureType ft, VirtualTable vt) {
        this.attributes.clear();
        for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
            SQLViewAttribute at = new SQLViewAttribute(ad.getLocalName(), ad.getType().getBinding());
            String attName = ad.getName().getLocalPart();
            this.attributes.add(at);
            if (ad instanceof GeometryDescriptor) {
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                if (gd.getUserData().get("nativeSRID") != null) {
                    at.setSrid((Integer)gd.getUserData().get("nativeSRID"));
                } else if (gd.getCoordinateReferenceSystem() != null) {
                    try {
                        at.setSrid(CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)false));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (vt != null && vt.getGeometries().contains(attName)) {
                    at.setSrid(vt.getNativeSrid(attName));
                    at.setType(vt.getGeometryType(attName));
                }
            }
            if (vt == null || vt.getPrimaryKeyColumns() == null || !vt.getPrimaryKeyColumns().contains(attName)) continue;
            at.setPk(true);
        }
    }

    @Override
    protected List getItems() {
        return this.attributes;
    }

    @Override
    protected List getProperties() {
        return Arrays.asList(NAME, TYPE, SRID, PK);
    }

    public void fillVirtualTable(VirtualTable vt) {
        ArrayList<String> pks = new ArrayList<String>();
        for (SQLViewAttribute att : this.attributes) {
            if (Geometry.class.isAssignableFrom(att.getType())) {
                if (att.getSrid() == null) {
                    vt.addGeometryMetadatata(att.getName(), att.getType(), 4326);
                } else {
                    vt.addGeometryMetadatata(att.getName(), att.getType(), att.getSrid().intValue());
                }
            }
            if (!att.pk) continue;
            pks.add(att.getName());
        }
        if (pks.size() > 0) {
            vt.setPrimaryKeyColumns(pks);
        }
    }
}

