/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layer.Resource;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.data.ows.Layer;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewLayerPageProvider
extends GeoServerDataProvider<Resource> {
    public static final GeoServerDataProvider.Property<Resource> PUBLISHED = new GeoServerDataProvider.BeanProperty<Resource>("published", "published");
    public static final GeoServerDataProvider.Property<Resource> NAME = new GeoServerDataProvider.BeanProperty<Resource>("name", "localName");
    public static final GeoServerDataProvider.Property<Resource> ACTION = new GeoServerDataProvider.PropertyPlaceholder<Resource>("action");
    public static final List<GeoServerDataProvider.Property<Resource>> PROPERTIES = Arrays.asList(PUBLISHED, NAME, ACTION);
    boolean showPublished;
    String storeId;

    @Override
    protected List<Resource> getItems() {
        if (this.storeId == null) {
            return new ArrayList<Resource>();
        }
        try {
            StoreInfo store = this.getCatalog().getStore(this.storeId, StoreInfo.class);
            HashMap<String, Resource> resources = new HashMap<String, Resource>();
            if (store instanceof DataStoreInfo) {
                DataStoreInfo dstore = (DataStoreInfo)store;
                List names = dstore.getDataStore(null).getNames();
                for (Name name : names) {
                    Catalog catalog = GeoServerApplication.get().getCatalog();
                    FeatureTypeInfo fti = catalog.getFeatureTypeByDataStore(dstore, name.getLocalPart());
                    if (fti != null && fti.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE") != null) continue;
                    resources.put(name.getLocalPart(), new Resource(name));
                }
            } else if (store instanceof CoverageStoreInfo) {
                CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
                builder.setStore(store);
                CoverageInfo ci = builder.buildCoverage();
                Name name = ci.getQualifiedName();
                resources.put(name.getLocalPart(), new Resource(name));
            } else if (store instanceof WMSStoreInfo) {
                WMSStoreInfo wmsInfo = (WMSStoreInfo)store;
                CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
                builder.setStore(store);
                List layers = wmsInfo.getWebMapServer(null).getCapabilities().getLayerList();
                for (Layer l : layers) {
                    if (l.getName() == null) continue;
                    resources.put(l.getName(), new Resource((Name)new NameImpl(l.getName())));
                }
            }
            List configuredTypes = this.getCatalog().getResourcesByStore(store, ResourceInfo.class);
            for (ResourceInfo type : configuredTypes) {
                Resource resource = (Resource)resources.get(type.getNativeName());
                if (resource == null) continue;
                resource.setPublished(true);
            }
            ArrayList<Resource> result = new ArrayList<Resource>(resources.values());
            Collections.sort(result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not list layers for this store, an error occurred retrieving them: " + e.getMessage(), e);
        }
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    protected List<Resource> getFilteredItems() {
        List<Resource> resources = super.getFilteredItems();
        if (this.showPublished) {
            return resources;
        }
        ArrayList<Resource> unconfigured = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (resource.isPublished()) continue;
            unconfigured.add(resource);
        }
        return unconfigured;
    }

    @Override
    protected List<GeoServerDataProvider.Property<Resource>> getProperties() {
        return PROPERTIES;
    }

    public void setShowPublished(boolean showPublished) {
        this.showPublished = showPublished;
    }
}

